/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.instrumentation;

import java.io.ByteArrayInputStream;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.instrumentation.JavassistHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogTransformer
implements ClassFileTransformer {
    private String level;
    private String levelEnabled;
    private boolean addEntryExit;
    private boolean verbose;
    private String[] ignore;
    private String loggerName;

    private LogTransformer(Builder builder) {
        String s = "WARNING: javassist not available on classpath for javaagent, log statements will not be added";
        try {
            if (Class.forName("javassist.ClassPool") == null) {
                System.err.println(s);
            }
        }
        catch (ClassNotFoundException e2) {
            System.err.println(s);
        }
        this.addEntryExit = builder.addEntryExit;
        this.verbose = builder.verbose;
        this.ignore = builder.ignore;
        this.level = builder.level;
        this.levelEnabled = "is" + builder.level.substring(0, 1).toUpperCase() + builder.level.substring(1) + "Enabled";
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> clazz, ProtectionDomain domain, byte[] bytes2) {
        try {
            return this.transform0(className, clazz, domain, bytes2);
        }
        catch (Exception e2) {
            System.err.println("Could not instrument " + className);
            e2.printStackTrace();
            return bytes2;
        }
    }

    private byte[] transform0(String className, Class<?> clazz, ProtectionDomain domain, byte[] bytes2) {
        try {
            for (int i = 0; i < this.ignore.length; ++i) {
                if (!className.startsWith(this.ignore[i])) continue;
                return bytes2;
            }
            String slf4jName = "org.slf4j.LoggerFactory";
            try {
                if (domain == null || domain.getClassLoader() == null) {
                    if (this.verbose) {
                        System.err.println("Skipping " + className + " as it doesn't have a domain or a class loader.");
                    }
                    return bytes2;
                }
                domain.getClassLoader().loadClass(slf4jName);
            }
            catch (ClassNotFoundException e2) {
                if (this.verbose) {
                    System.err.println("Skipping " + className + " as slf4j is not available to it");
                }
                return bytes2;
            }
            if (this.verbose) {
                System.err.println("Processing " + className);
            }
            return this.doClass(className, clazz, bytes2);
        }
        catch (Throwable e3) {
            System.out.println("e = " + e3);
            return bytes2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] doClass(String name2, Class<?> clazz, byte[] b) {
        ClassPool pool = ClassPool.getDefault();
        CtClass cl = null;
        try {
            cl = pool.makeClass(new ByteArrayInputStream(b));
            if (!cl.isInterface()) {
                this.loggerName = "_____log";
                String pattern1 = "private static org.slf4j.Logger {};";
                String loggerDefinition = MessageFormatter.format(pattern1, this.loggerName).getMessage();
                CtField field = CtField.make(loggerDefinition, cl);
                String pattern2 = "org.slf4j.LoggerFactory.getLogger({}.class);";
                String replace2 = name2.replace('/', '.');
                String getLogger = MessageFormatter.format(pattern2, replace2).getMessage();
                cl.addField(field, getLogger);
                CtBehavior[] methods2 = cl.getDeclaredBehaviors();
                for (int i = 0; i < methods2.length; ++i) {
                    if (methods2[i].isEmpty()) continue;
                    this.doMethod(methods2[i]);
                }
                b = cl.toBytecode();
            }
        }
        catch (Exception e2) {
            System.err.println("Could not instrument " + name2 + ", " + e2);
            e2.printStackTrace(System.err);
        }
        finally {
            if (cl != null) {
                cl.detach();
            }
        }
        return b;
    }

    private void doMethod(CtBehavior method) throws NotFoundException, CannotCompileException {
        String signature = JavassistHelper.getSignature(method);
        String returnValue = JavassistHelper.returnValue(method);
        if (this.addEntryExit) {
            String messagePattern = "if ({}.{}()) {}.{}(\">> {}\");";
            Object[] arg1 = new Object[]{this.loggerName, this.levelEnabled, this.loggerName, this.level, signature};
            String before = MessageFormatter.arrayFormat(messagePattern, arg1).getMessage();
            method.insertBefore(before);
            String messagePattern2 = "if ({}.{}()) {}.{}(\"<< {}{}\");";
            Object[] arg2 = new Object[]{this.loggerName, this.levelEnabled, this.loggerName, this.level, signature, returnValue};
            String after = MessageFormatter.arrayFormat(messagePattern2, arg2).getMessage();
            method.insertAfter(after);
        }
    }

    public static class Builder {
        boolean addEntryExit;
        boolean addVariableAssignment;
        boolean verbose;
        String[] ignore = new String[]{"org/slf4j/", "ch/qos/logback/", "org/apache/log4j/"};
        private String level = "info";

        public LogTransformer build() {
            if (this.verbose) {
                System.err.println("Creating LogTransformer");
            }
            return new LogTransformer(this);
        }

        public Builder addEntryExit(boolean b) {
            this.addEntryExit = b;
            return this;
        }

        public Builder verbose(boolean b) {
            this.verbose = b;
            return this;
        }

        public Builder ignore(String[] strings) {
            this.ignore = strings;
            return this;
        }

        public Builder level(String level) {
            if ((level = level.toLowerCase()).equals("info") || level.equals("debug") || level.equals("trace")) {
                this.level = level;
            } else if (this.verbose) {
                System.err.println("level not info/debug/trace : " + level);
            }
            return this;
        }
    }
}

