/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import org.springframework.core.NamedThreadLocal;

public abstract class AopContext {
    private static final ThreadLocal<Object> currentProxy = new NamedThreadLocal<Object>("Current AOP proxy");

    public static Object currentProxy() throws IllegalStateException {
        Object proxy2 = currentProxy.get();
        if (proxy2 == null) {
            throw new IllegalStateException("Cannot find current proxy: Set 'exposeProxy' property on Advised to 'true' to make it available.");
        }
        return proxy2;
    }

    static Object setCurrentProxy(Object proxy2) {
        Object old = currentProxy.get();
        if (proxy2 != null) {
            currentProxy.set(proxy2);
        } else {
            currentProxy.remove();
        }
        return old;
    }
}

