/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.AbstractPropertyAccessor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.MethodInvocationException;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.NullValueInNestedPathException;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.TypeConverterDelegate;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.CollectionFactory;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.lang.UsesJava8;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractNestablePropertyAccessor
extends AbstractPropertyAccessor {
    private static final Log logger = LogFactory.getLog(AbstractNestablePropertyAccessor.class);
    private static Class<?> javaUtilOptionalClass = null;
    private int autoGrowCollectionLimit = Integer.MAX_VALUE;
    private Object object;
    private String nestedPath = "";
    private Object rootObject;
    private Map<String, AbstractNestablePropertyAccessor> nestedPropertyAccessors;

    protected AbstractNestablePropertyAccessor() {
        this(true);
    }

    protected AbstractNestablePropertyAccessor(boolean registerDefaultEditors) {
        if (registerDefaultEditors) {
            this.registerDefaultEditors();
        }
        this.typeConverterDelegate = new TypeConverterDelegate(this);
    }

    protected AbstractNestablePropertyAccessor(Object object) {
        this.registerDefaultEditors();
        this.setWrappedInstance(object);
    }

    protected AbstractNestablePropertyAccessor(Class<?> clazz) {
        this.registerDefaultEditors();
        this.setWrappedInstance(BeanUtils.instantiateClass(clazz));
    }

    protected AbstractNestablePropertyAccessor(Object object, String nestedPath, Object rootObject) {
        this.registerDefaultEditors();
        this.setWrappedInstance(object, nestedPath, rootObject);
    }

    protected AbstractNestablePropertyAccessor(Object object, String nestedPath, AbstractNestablePropertyAccessor parent) {
        this.setWrappedInstance(object, nestedPath, parent.getWrappedInstance());
        this.setExtractOldValueForEditor(parent.isExtractOldValueForEditor());
        this.setAutoGrowNestedPaths(parent.isAutoGrowNestedPaths());
        this.setAutoGrowCollectionLimit(parent.getAutoGrowCollectionLimit());
        this.setConversionService(parent.getConversionService());
    }

    public void setAutoGrowCollectionLimit(int autoGrowCollectionLimit) {
        this.autoGrowCollectionLimit = autoGrowCollectionLimit;
    }

    public int getAutoGrowCollectionLimit() {
        return this.autoGrowCollectionLimit;
    }

    public void setWrappedInstance(Object object) {
        this.setWrappedInstance(object, "", null);
    }

    public void setWrappedInstance(Object object, String nestedPath, Object rootObject) {
        Assert.notNull(object, "Bean object must not be null");
        this.object = object.getClass().equals(javaUtilOptionalClass) ? OptionalUnwrapper.unwrap(object) : object;
        this.nestedPath = nestedPath != null ? nestedPath : "";
        this.rootObject = !"".equals(this.nestedPath) ? rootObject : this.object;
        this.nestedPropertyAccessors = null;
        this.typeConverterDelegate = new TypeConverterDelegate(this, this.object);
    }

    public final Object getWrappedInstance() {
        return this.object;
    }

    public final Class<?> getWrappedClass() {
        return this.object != null ? this.object.getClass() : null;
    }

    public final String getNestedPath() {
        return this.nestedPath;
    }

    public final Object getRootInstance() {
        return this.rootObject;
    }

    public final Class<?> getRootClass() {
        return this.rootObject != null ? this.rootObject.getClass() : null;
    }

    @Override
    public void setPropertyValue(String propertyName, Object value) throws BeansException {
        AbstractNestablePropertyAccessor nestedPa;
        try {
            nestedPa = this.getPropertyAccessorForPropertyPath(propertyName);
        }
        catch (NotReadablePropertyException ex) {
            throw new NotWritablePropertyException(this.getRootClass(), this.nestedPath + propertyName, "Nested property in path '" + propertyName + "' does not exist", ex);
        }
        PropertyTokenHolder tokens = this.getPropertyNameTokens(this.getFinalPath(nestedPa, propertyName));
        nestedPa.setPropertyValue(tokens, new PropertyValue(propertyName, value));
    }

    @Override
    public void setPropertyValue(PropertyValue pv) throws BeansException {
        PropertyTokenHolder tokens = (PropertyTokenHolder)pv.resolvedTokens;
        if (tokens == null) {
            AbstractNestablePropertyAccessor nestedPa;
            String propertyName = pv.getName();
            try {
                nestedPa = this.getPropertyAccessorForPropertyPath(propertyName);
            }
            catch (NotReadablePropertyException ex) {
                throw new NotWritablePropertyException(this.getRootClass(), this.nestedPath + propertyName, "Nested property in path '" + propertyName + "' does not exist", ex);
            }
            tokens = this.getPropertyNameTokens(this.getFinalPath(nestedPa, propertyName));
            if (nestedPa == this) {
                pv.getOriginalPropertyValue().resolvedTokens = tokens;
            }
            nestedPa.setPropertyValue(tokens, pv);
        } else {
            this.setPropertyValue(tokens, pv);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setPropertyValue(PropertyTokenHolder tokens, PropertyValue pv) throws BeansException {
        String propertyName = tokens.canonicalName;
        String actualName = tokens.actualName;
        if (tokens.keys != null) {
            Object propValue;
            PropertyTokenHolder getterTokens = new PropertyTokenHolder();
            getterTokens.canonicalName = tokens.canonicalName;
            getterTokens.actualName = tokens.actualName;
            getterTokens.keys = new String[tokens.keys.length - 1];
            System.arraycopy(tokens.keys, 0, getterTokens.keys, 0, tokens.keys.length - 1);
            try {
                propValue = this.getPropertyValue(getterTokens);
            }
            catch (NotReadablePropertyException ex) {
                throw new NotWritablePropertyException(this.getRootClass(), this.nestedPath + propertyName, "Cannot access indexed value in property referenced in indexed property path '" + propertyName + "'", ex);
            }
            String key2 = tokens.keys[tokens.keys.length - 1];
            if (propValue == null) {
                if (!this.isAutoGrowNestedPaths()) throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + propertyName, "Cannot access indexed value in property referenced in indexed property path '" + propertyName + "': returned null");
                int lastKeyIndex = tokens.canonicalName.lastIndexOf(91);
                getterTokens.canonicalName = tokens.canonicalName.substring(0, lastKeyIndex);
                propValue = this.setDefaultValue(getterTokens);
            }
            if (propValue.getClass().isArray()) {
                PropertyHandler ph = this.getLocalPropertyHandler(actualName);
                Class<?> requiredType = propValue.getClass().getComponentType();
                int arrayIndex = Integer.parseInt(key2);
                Object oldValue = null;
                try {
                    if (this.isExtractOldValueForEditor() && arrayIndex < Array.getLength(propValue)) {
                        oldValue = Array.get(propValue, arrayIndex);
                    }
                    Object convertedValue = this.convertIfNecessary(propertyName, oldValue, pv.getValue(), requiredType, ph.nested(tokens.keys.length));
                    int length = Array.getLength(propValue);
                    if (arrayIndex >= length && arrayIndex < this.autoGrowCollectionLimit) {
                        Class<?> componentType = propValue.getClass().getComponentType();
                        Object newArray = Array.newInstance(componentType, arrayIndex + 1);
                        System.arraycopy(propValue, 0, newArray, 0, length);
                        this.setPropertyValue(actualName, newArray);
                        propValue = this.getPropertyValue(actualName);
                    }
                    Array.set(propValue, arrayIndex, convertedValue);
                    return;
                }
                catch (IndexOutOfBoundsException ex) {
                    throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Invalid array index in property path '" + propertyName + "'", ex);
                }
            } else if (propValue instanceof List) {
                PropertyHandler ph = this.getPropertyHandler(actualName);
                Class<?> requiredType = ph.getCollectionType(tokens.keys.length);
                List list = (List)propValue;
                int index2 = Integer.parseInt(key2);
                Object oldValue = null;
                if (this.isExtractOldValueForEditor() && index2 < list.size()) {
                    oldValue = list.get(index2);
                }
                Object convertedValue = this.convertIfNecessary(propertyName, oldValue, pv.getValue(), requiredType, ph.nested(tokens.keys.length));
                int size = list.size();
                if (index2 >= size && index2 < this.autoGrowCollectionLimit) {
                    for (int i = size; i < index2; ++i) {
                        try {
                            list.add(null);
                            continue;
                        }
                        catch (NullPointerException ex) {
                            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Cannot set element with index " + index2 + " in List of size " + size + ", accessed using property path '" + propertyName + "': List does not support filling up gaps with null elements");
                        }
                    }
                    list.add(convertedValue);
                    return;
                } else {
                    try {
                        list.set(index2, convertedValue);
                        return;
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Invalid list index in property path '" + propertyName + "'", ex);
                    }
                }
            } else {
                if (!(propValue instanceof Map)) throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Property referenced in indexed property path '" + propertyName + "' is neither an array nor a List nor a Map; returned value was [" + propValue + "]");
                PropertyHandler ph = this.getLocalPropertyHandler(actualName);
                Class<?> mapKeyType = ph.getMapKeyType(tokens.keys.length);
                Class<?> mapValueType = ph.getMapValueType(tokens.keys.length);
                Map map2 = (Map)propValue;
                TypeDescriptor typeDescriptor = TypeDescriptor.valueOf(mapKeyType);
                Object convertedMapKey = this.convertIfNecessary(null, null, key2, mapKeyType, typeDescriptor);
                Object oldValue = null;
                if (this.isExtractOldValueForEditor()) {
                    oldValue = map2.get(convertedMapKey);
                }
                Object convertedMapValue = this.convertIfNecessary(propertyName, oldValue, pv.getValue(), mapValueType, ph.nested(tokens.keys.length));
                map2.put(convertedMapKey, convertedMapValue);
            }
            return;
        }
        PropertyHandler ph = this.getLocalPropertyHandler(actualName);
        if (ph == null || !ph.isWritable()) {
            if (!pv.isOptional()) throw this.createNotWritablePropertyException(propertyName);
            if (!logger.isDebugEnabled()) return;
            logger.debug("Ignoring optional value for property '" + actualName + "' - property not found on bean class [" + this.getRootClass().getName() + "]");
            return;
        }
        Object oldValue = null;
        try {
            Object originalValue;
            Object valueToApply = originalValue = pv.getValue();
            if (!Boolean.FALSE.equals(pv.conversionNecessary)) {
                if (pv.isConverted()) {
                    valueToApply = pv.getConvertedValue();
                } else {
                    block34: {
                        if (this.isExtractOldValueForEditor() && ph.isReadable()) {
                            try {
                                oldValue = ph.getValue();
                            }
                            catch (Exception ex) {
                                if (ex instanceof PrivilegedActionException) {
                                    ex = ((PrivilegedActionException)ex).getException();
                                }
                                if (!logger.isDebugEnabled()) break block34;
                                logger.debug("Could not read previous value of property '" + this.nestedPath + propertyName + "'", ex);
                            }
                        }
                    }
                    valueToApply = this.convertForProperty(propertyName, oldValue, originalValue, ph.toTypeDescriptor());
                }
                pv.getOriginalPropertyValue().conversionNecessary = valueToApply != originalValue;
            }
            ph.setValue(this.object, valueToApply);
            return;
        }
        catch (TypeMismatchException ex) {
            throw ex;
        }
        catch (InvocationTargetException ex) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.rootObject, this.nestedPath + propertyName, oldValue, pv.getValue());
            if (ex.getTargetException() instanceof ClassCastException) {
                throw new TypeMismatchException(propertyChangeEvent, ph.getPropertyType(), ex.getTargetException());
            }
            Throwable cause = ex.getTargetException();
            if (!(cause instanceof UndeclaredThrowableException)) throw new MethodInvocationException(propertyChangeEvent, cause);
            cause = cause.getCause();
            throw new MethodInvocationException(propertyChangeEvent, cause);
        }
        catch (Exception ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.rootObject, this.nestedPath + propertyName, oldValue, pv.getValue());
            throw new MethodInvocationException(pce, (Throwable)ex);
        }
    }

    @Override
    public Class<?> getPropertyType(String propertyName) throws BeansException {
        try {
            PropertyHandler ph = this.getPropertyHandler(propertyName);
            if (ph != null) {
                return ph.getPropertyType();
            }
            Object value = this.getPropertyValue(propertyName);
            if (value != null) {
                return value.getClass();
            }
            Class<?> editorType = this.guessPropertyTypeFromEditors(propertyName);
            if (editorType != null) {
                return editorType;
            }
        }
        catch (InvalidPropertyException invalidPropertyException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public TypeDescriptor getPropertyTypeDescriptor(String propertyName) throws BeansException {
        try {
            AbstractNestablePropertyAccessor nestedPa = this.getPropertyAccessorForPropertyPath(propertyName);
            String finalPath = this.getFinalPath(nestedPa, propertyName);
            PropertyTokenHolder tokens = this.getPropertyNameTokens(finalPath);
            PropertyHandler ph = nestedPa.getLocalPropertyHandler(tokens.actualName);
            if (ph != null) {
                if (tokens.keys != null) {
                    if (ph.isReadable() || ph.isWritable()) {
                        return ph.nested(tokens.keys.length);
                    }
                } else if (ph.isReadable() || ph.isWritable()) {
                    return ph.toTypeDescriptor();
                }
            }
        }
        catch (InvalidPropertyException invalidPropertyException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean isReadableProperty(String propertyName) {
        try {
            PropertyHandler ph = this.getPropertyHandler(propertyName);
            if (ph != null) {
                return ph.isReadable();
            }
            this.getPropertyValue(propertyName);
            return true;
        }
        catch (InvalidPropertyException invalidPropertyException) {
            return false;
        }
    }

    @Override
    public boolean isWritableProperty(String propertyName) {
        try {
            PropertyHandler ph = this.getPropertyHandler(propertyName);
            if (ph != null) {
                return ph.isWritable();
            }
            this.getPropertyValue(propertyName);
            return true;
        }
        catch (InvalidPropertyException invalidPropertyException) {
            return false;
        }
    }

    private Object convertIfNecessary(String propertyName, Object oldValue, Object newValue, Class<?> requiredType, TypeDescriptor td) throws TypeMismatchException {
        try {
            return this.typeConverterDelegate.convertIfNecessary(propertyName, oldValue, newValue, requiredType, td);
        }
        catch (ConverterNotFoundException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.rootObject, this.nestedPath + propertyName, oldValue, newValue);
            throw new ConversionNotSupportedException(pce, td.getType(), (Throwable)ex);
        }
        catch (ConversionException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.rootObject, this.nestedPath + propertyName, oldValue, newValue);
            throw new TypeMismatchException(pce, requiredType, (Throwable)ex);
        }
        catch (IllegalStateException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.rootObject, this.nestedPath + propertyName, oldValue, newValue);
            throw new ConversionNotSupportedException(pce, requiredType, (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.rootObject, this.nestedPath + propertyName, oldValue, newValue);
            throw new TypeMismatchException(pce, requiredType, (Throwable)ex);
        }
    }

    protected Object convertForProperty(String propertyName, Object oldValue, Object newValue, TypeDescriptor td) throws TypeMismatchException {
        return this.convertIfNecessary(propertyName, oldValue, newValue, td.getType(), td);
    }

    @Override
    public Object getPropertyValue(String propertyName) throws BeansException {
        AbstractNestablePropertyAccessor nestedPa = this.getPropertyAccessorForPropertyPath(propertyName);
        PropertyTokenHolder tokens = this.getPropertyNameTokens(this.getFinalPath(nestedPa, propertyName));
        return nestedPa.getPropertyValue(tokens);
    }

    protected Object getPropertyValue(PropertyTokenHolder tokens) throws BeansException {
        String propertyName = tokens.canonicalName;
        String actualName = tokens.actualName;
        PropertyHandler ph = this.getLocalPropertyHandler(actualName);
        if (ph == null || !ph.isReadable()) {
            throw new NotReadablePropertyException(this.getRootClass(), this.nestedPath + propertyName);
        }
        try {
            Object value = ph.getValue();
            if (tokens.keys != null) {
                if (value == null) {
                    if (this.isAutoGrowNestedPaths()) {
                        value = this.setDefaultValue(tokens.actualName);
                    } else {
                        throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + propertyName, "Cannot access indexed value of property referenced in indexed property path '" + propertyName + "': returned null");
                    }
                }
                String indexedPropertyName = tokens.actualName;
                for (int i = 0; i < tokens.keys.length; ++i) {
                    String key2 = tokens.keys[i];
                    if (value == null) {
                        throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + propertyName, "Cannot access indexed value of property referenced in indexed property path '" + propertyName + "': returned null");
                    }
                    if (value.getClass().isArray()) {
                        int index2 = Integer.parseInt(key2);
                        value = this.growArrayIfNecessary(value, index2, indexedPropertyName);
                        value = Array.get(value, index2);
                    } else if (value instanceof List) {
                        int index3 = Integer.parseInt(key2);
                        List list = (List)value;
                        this.growCollectionIfNecessary(list, index3, indexedPropertyName, ph, i + 1);
                        value = list.get(index3);
                    } else if (value instanceof Set) {
                        Set set2 = (Set)value;
                        int index4 = Integer.parseInt(key2);
                        if (index4 < 0 || index4 >= set2.size()) {
                            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Cannot get element with index " + index4 + " from Set of size " + set2.size() + ", accessed using property path '" + propertyName + "'");
                        }
                        Iterator it = set2.iterator();
                        int j = 0;
                        while (it.hasNext()) {
                            Object elem = it.next();
                            if (j == index4) {
                                value = elem;
                                break;
                            }
                            ++j;
                        }
                    } else if (value instanceof Map) {
                        Map map2 = (Map)value;
                        Class<?> mapKeyType = ph.getResolvableType().getNested(i + 1).asMap().resolveGeneric(0);
                        TypeDescriptor typeDescriptor = TypeDescriptor.valueOf(mapKeyType);
                        Object convertedMapKey = this.convertIfNecessary(null, null, key2, mapKeyType, typeDescriptor);
                        value = map2.get(convertedMapKey);
                    } else {
                        throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Property referenced in indexed property path '" + propertyName + "' is neither an array nor a List nor a Set nor a Map; returned value was [" + value + "]");
                    }
                    indexedPropertyName = indexedPropertyName + "[" + key2 + "]";
                }
            }
            return value;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Index of out of bounds in property path '" + propertyName + "'", ex);
        }
        catch (NumberFormatException ex) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Invalid index in property path '" + propertyName + "'", ex);
        }
        catch (TypeMismatchException ex) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Invalid index in property path '" + propertyName + "'", ex);
        }
        catch (InvocationTargetException ex) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Getter for property '" + actualName + "' threw exception", ex);
        }
        catch (Exception ex) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Illegal attempt to get property '" + actualName + "' threw exception", ex);
        }
    }

    protected PropertyHandler getPropertyHandler(String propertyName) throws BeansException {
        Assert.notNull(propertyName, "Property name must not be null");
        AbstractNestablePropertyAccessor nestedPa = this.getPropertyAccessorForPropertyPath(propertyName);
        return nestedPa.getLocalPropertyHandler(this.getFinalPath(nestedPa, propertyName));
    }

    protected abstract PropertyHandler getLocalPropertyHandler(String var1);

    protected abstract AbstractNestablePropertyAccessor newNestedPropertyAccessor(Object var1, String var2);

    protected abstract NotWritablePropertyException createNotWritablePropertyException(String var1);

    private Object growArrayIfNecessary(Object array2, int index2, String name2) {
        if (!this.isAutoGrowNestedPaths()) {
            return array2;
        }
        int length = Array.getLength(array2);
        if (index2 >= length && index2 < this.autoGrowCollectionLimit) {
            Class<?> componentType = array2.getClass().getComponentType();
            Object newArray = Array.newInstance(componentType, index2 + 1);
            System.arraycopy(array2, 0, newArray, 0, length);
            for (int i = length; i < Array.getLength(newArray); ++i) {
                Array.set(newArray, i, this.newValue(componentType, null, name2));
            }
            this.setPropertyValue(name2, newArray);
            return this.getPropertyValue(name2);
        }
        return array2;
    }

    private void growCollectionIfNecessary(Collection<Object> collection, int index2, String name2, PropertyHandler ph, int nestingLevel) {
        Class<?> elementType;
        if (!this.isAutoGrowNestedPaths()) {
            return;
        }
        int size = collection.size();
        if (index2 >= size && index2 < this.autoGrowCollectionLimit && (elementType = ph.getResolvableType().getNested(nestingLevel).asCollection().resolveGeneric(new int[0])) != null) {
            for (int i = collection.size(); i < index2 + 1; ++i) {
                collection.add(this.newValue(elementType, null, name2));
            }
        }
    }

    private String getFinalPath(AbstractNestablePropertyAccessor pa, String nestedPath) {
        if (pa == this) {
            return nestedPath;
        }
        return nestedPath.substring(PropertyAccessorUtils.getLastNestedPropertySeparatorIndex(nestedPath) + 1);
    }

    protected AbstractNestablePropertyAccessor getPropertyAccessorForPropertyPath(String propertyPath) {
        int pos = PropertyAccessorUtils.getFirstNestedPropertySeparatorIndex(propertyPath);
        if (pos > -1) {
            String nestedProperty = propertyPath.substring(0, pos);
            String nestedPath = propertyPath.substring(pos + 1);
            AbstractNestablePropertyAccessor nestedPa = this.getNestedPropertyAccessor(nestedProperty);
            return nestedPa.getPropertyAccessorForPropertyPath(nestedPath);
        }
        return this;
    }

    private AbstractNestablePropertyAccessor getNestedPropertyAccessor(String nestedProperty) {
        AbstractNestablePropertyAccessor nestedPa;
        if (this.nestedPropertyAccessors == null) {
            this.nestedPropertyAccessors = new HashMap<String, AbstractNestablePropertyAccessor>();
        }
        PropertyTokenHolder tokens = this.getPropertyNameTokens(nestedProperty);
        String canonicalName = tokens.canonicalName;
        Object value = this.getPropertyValue(tokens);
        if (value == null || value.getClass().equals(javaUtilOptionalClass) && OptionalUnwrapper.isEmpty(value)) {
            if (this.isAutoGrowNestedPaths()) {
                value = this.setDefaultValue(tokens);
            } else {
                throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + canonicalName);
            }
        }
        if ((nestedPa = this.nestedPropertyAccessors.get(canonicalName)) == null || nestedPa.getWrappedInstance() != (value.getClass().equals(javaUtilOptionalClass) ? OptionalUnwrapper.unwrap(value) : value)) {
            if (logger.isTraceEnabled()) {
                logger.trace("Creating new nested " + this.getClass().getSimpleName() + " for property '" + canonicalName + "'");
            }
            nestedPa = this.newNestedPropertyAccessor(value, this.nestedPath + canonicalName + ".");
            this.copyDefaultEditorsTo(nestedPa);
            this.copyCustomEditorsTo(nestedPa, canonicalName);
            this.nestedPropertyAccessors.put(canonicalName, nestedPa);
        } else if (logger.isTraceEnabled()) {
            logger.trace("Using cached nested property accessor for property '" + canonicalName + "'");
        }
        return nestedPa;
    }

    private Object setDefaultValue(String propertyName) {
        PropertyTokenHolder tokens = new PropertyTokenHolder();
        tokens.actualName = propertyName;
        tokens.canonicalName = propertyName;
        return this.setDefaultValue(tokens);
    }

    private Object setDefaultValue(PropertyTokenHolder tokens) {
        PropertyValue pv = this.createDefaultPropertyValue(tokens);
        this.setPropertyValue(tokens, pv);
        return this.getPropertyValue(tokens);
    }

    private PropertyValue createDefaultPropertyValue(PropertyTokenHolder tokens) {
        TypeDescriptor desc = this.getPropertyTypeDescriptor(tokens.canonicalName);
        Class<?> type2 = desc.getType();
        if (type2 == null) {
            throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + tokens.canonicalName, "Could not determine property type for auto-growing a default value");
        }
        Object defaultValue = this.newValue(type2, desc, tokens.canonicalName);
        return new PropertyValue(tokens.canonicalName, defaultValue);
    }

    private Object newValue(Class<?> type2, TypeDescriptor desc, String name2) {
        try {
            if (type2.isArray()) {
                Class<?> componentType = type2.getComponentType();
                if (componentType.isArray()) {
                    Object array2 = Array.newInstance(componentType, 1);
                    Array.set(array2, 0, Array.newInstance(componentType.getComponentType(), 0));
                    return array2;
                }
                return Array.newInstance(componentType, 0);
            }
            if (Collection.class.isAssignableFrom(type2)) {
                TypeDescriptor elementDesc = desc != null ? desc.getElementTypeDescriptor() : null;
                return CollectionFactory.createCollection(type2, elementDesc != null ? elementDesc.getType() : null, 16);
            }
            if (Map.class.isAssignableFrom(type2)) {
                TypeDescriptor keyDesc = desc != null ? desc.getMapKeyTypeDescriptor() : null;
                return CollectionFactory.createMap(type2, keyDesc != null ? keyDesc.getType() : null, 16);
            }
            return BeanUtils.instantiate(type2);
        }
        catch (Exception ex) {
            throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + name2, "Could not instantiate property type [" + type2.getName() + "] to auto-grow nested property path: " + ex);
        }
    }

    private PropertyTokenHolder getPropertyNameTokens(String propertyName) {
        PropertyTokenHolder tokens = new PropertyTokenHolder();
        String actualName = null;
        ArrayList<String> keys2 = new ArrayList<String>(2);
        int searchIndex = 0;
        while (searchIndex != -1) {
            String key2;
            int keyEnd;
            int keyStart = propertyName.indexOf("[", searchIndex);
            searchIndex = -1;
            if (keyStart == -1 || (keyEnd = propertyName.indexOf("]", keyStart + "[".length())) == -1) continue;
            if (actualName == null) {
                actualName = propertyName.substring(0, keyStart);
            }
            if ((key2 = propertyName.substring(keyStart + "[".length(), keyEnd)).startsWith("'") && key2.endsWith("'") || key2.startsWith("\"") && key2.endsWith("\"")) {
                key2 = key2.substring(1, key2.length() - 1);
            }
            keys2.add(key2);
            searchIndex = keyEnd + "]".length();
        }
        tokens.canonicalName = tokens.actualName = actualName != null ? actualName : propertyName;
        if (!keys2.isEmpty()) {
            tokens.canonicalName = tokens.canonicalName + "[" + StringUtils.collectionToDelimitedString(keys2, "][") + "]";
            tokens.keys = StringUtils.toStringArray(keys2);
        }
        return tokens;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        if (this.object != null) {
            sb.append(": wrapping object [").append(ObjectUtils.identityToString(this.object)).append("]");
        } else {
            sb.append(": no wrapped object set");
        }
        return sb.toString();
    }

    static {
        try {
            javaUtilOptionalClass = ClassUtils.forName("java.util.Optional", AbstractNestablePropertyAccessor.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @UsesJava8
    private static class OptionalUnwrapper {
        private OptionalUnwrapper() {
        }

        public static Object unwrap(Object optionalObject) {
            Optional optional = (Optional)optionalObject;
            Assert.isTrue(optional.isPresent(), "Optional value must be present");
            Object result = optional.get();
            Assert.isTrue(!(result instanceof Optional), "Multi-level Optional usage not supported");
            return result;
        }

        public static boolean isEmpty(Object optionalObject) {
            return !((Optional)optionalObject).isPresent();
        }
    }

    protected static class PropertyTokenHolder {
        public String canonicalName;
        public String actualName;
        public String[] keys;

        protected PropertyTokenHolder() {
        }
    }

    protected static abstract class PropertyHandler {
        private final Class<?> propertyType;
        private final boolean readable;
        private final boolean writable;

        public PropertyHandler(Class<?> propertyType, boolean readable, boolean writable) {
            this.propertyType = propertyType;
            this.readable = readable;
            this.writable = writable;
        }

        public Class<?> getPropertyType() {
            return this.propertyType;
        }

        public boolean isReadable() {
            return this.readable;
        }

        public boolean isWritable() {
            return this.writable;
        }

        public abstract TypeDescriptor toTypeDescriptor();

        public abstract ResolvableType getResolvableType();

        public Class<?> getMapKeyType(int nestingLevel) {
            return this.getResolvableType().getNested(nestingLevel).asMap().resolveGeneric(0);
        }

        public Class<?> getMapValueType(int nestingLevel) {
            return this.getResolvableType().getNested(nestingLevel).asMap().resolveGeneric(1);
        }

        public Class<?> getCollectionType(int nestingLevel) {
            return this.getResolvableType().getNested(nestingLevel).asCollection().resolveGeneric(new int[0]);
        }

        public abstract TypeDescriptor nested(int var1);

        public abstract Object getValue() throws Exception;

        public abstract void setValue(Object var1, Object var2) throws Exception;
    }
}

