/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory;

import java.util.Arrays;
import java.util.Collection;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.util.StringUtils;

public class NoUniqueBeanDefinitionException
extends NoSuchBeanDefinitionException {
    private int numberOfBeansFound;

    public NoUniqueBeanDefinitionException(Class<?> type2, int numberOfBeansFound, String message) {
        super(type2, message);
        this.numberOfBeansFound = numberOfBeansFound;
    }

    public NoUniqueBeanDefinitionException(Class<?> type2, Collection<String> beanNamesFound) {
        this(type2, beanNamesFound.size(), "expected single matching bean but found " + beanNamesFound.size() + ": " + StringUtils.collectionToCommaDelimitedString(beanNamesFound));
    }

    public NoUniqueBeanDefinitionException(Class<?> type2, String ... beanNamesFound) {
        this(type2, Arrays.asList(beanNamesFound));
    }

    @Override
    public int getNumberOfBeansFound() {
        return this.numberOfBeansFound;
    }
}

