/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.io.IOException;
import java.io.Reader;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.parser.ParserException;
import org.yaml.snakeyaml.reader.UnicodeReader;

public abstract class YamlProcessor {
    private final Log logger = LogFactory.getLog(this.getClass());
    private ResolutionMethod resolutionMethod = ResolutionMethod.OVERRIDE;
    private Resource[] resources = new Resource[0];
    private List<DocumentMatcher> documentMatchers = Collections.emptyList();
    private boolean matchDefault = true;

    public void setDocumentMatchers(DocumentMatcher ... matchers) {
        this.documentMatchers = Arrays.asList(matchers);
    }

    public void setMatchDefault(boolean matchDefault) {
        this.matchDefault = matchDefault;
    }

    public void setResolutionMethod(ResolutionMethod resolutionMethod) {
        Assert.notNull((Object)resolutionMethod, "ResolutionMethod must not be null");
        this.resolutionMethod = resolutionMethod;
    }

    public void setResources(Resource ... resources) {
        this.resources = resources;
    }

    protected void process(MatchCallback callback) {
        Yaml yaml = this.createYaml();
        for (Resource resource2 : this.resources) {
            boolean found = this.process(callback, yaml, resource2);
            if (this.resolutionMethod != ResolutionMethod.FIRST_FOUND || !found) continue;
            return;
        }
    }

    protected Yaml createYaml() {
        return new Yaml((BaseConstructor)new StrictMapAppenderConstructor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean process(MatchCallback callback, Yaml yaml, Resource resource2) {
        int count2 = 0;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Loading from YAML: " + resource2);
            }
            UnicodeReader reader2 = new UnicodeReader(resource2.getInputStream());
            try {
                for (Object object : yaml.loadAll((Reader)reader2)) {
                    if (object == null || !this.process(this.asMap(object), callback)) continue;
                    ++count2;
                    if (this.resolutionMethod != ResolutionMethod.FIRST_FOUND) continue;
                    break;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Loaded " + count2 + " document" + (count2 > 1 ? "s" : "") + " from YAML resource: " + resource2);
                }
            }
            finally {
                reader2.close();
            }
        }
        catch (IOException ex) {
            this.handleProcessError(resource2, ex);
        }
        return count2 > 0;
    }

    private void handleProcessError(Resource resource2, IOException ex) {
        if (this.resolutionMethod != ResolutionMethod.FIRST_FOUND && this.resolutionMethod != ResolutionMethod.OVERRIDE_AND_IGNORE) {
            throw new IllegalStateException(ex);
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("Could not load map from " + resource2 + ": " + ex.getMessage());
        }
    }

    private Map<String, Object> asMap(Object object) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (!(object instanceof Map)) {
            result.put("document", object);
            return result;
        }
        Map map2 = (Map)object;
        for (Map.Entry entry : map2.entrySet()) {
            Object key2;
            Object value = entry.getValue();
            if (value instanceof Map) {
                value = this.asMap(value);
            }
            if ((key2 = entry.getKey()) instanceof CharSequence) {
                result.put(key2.toString(), value);
                continue;
            }
            result.put("[" + key2.toString() + "]", value);
        }
        return result;
    }

    private boolean process(Map<String, Object> map2, MatchCallback callback) {
        Properties properties = new Properties();
        properties.putAll(this.getFlattenedMap(map2));
        if (this.documentMatchers.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Merging document (no matchers set)" + map2);
            }
            callback.process(properties, map2);
            return true;
        }
        MatchStatus result = MatchStatus.ABSTAIN;
        for (DocumentMatcher matcher : this.documentMatchers) {
            MatchStatus match = matcher.matches(properties);
            result = MatchStatus.getMostSpecific(match, result);
            if (match != MatchStatus.FOUND) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Matched document with document matcher: " + properties);
            }
            callback.process(properties, map2);
            return true;
        }
        if (result == MatchStatus.ABSTAIN && this.matchDefault) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Matched document with default matcher: " + map2);
            }
            callback.process(properties, map2);
            return true;
        }
        this.logger.debug("Unmatched document");
        return false;
    }

    protected final Map<String, Object> getFlattenedMap(Map<String, Object> source2) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this.buildFlattenedMap(result, source2, null);
        return result;
    }

    private void buildFlattenedMap(Map<String, Object> result, Map<String, Object> source2, String path2) {
        for (Map.Entry<String, Object> entry : source2.entrySet()) {
            Object value;
            String key2 = entry.getKey();
            if (StringUtils.hasText(path2)) {
                key2 = key2.startsWith("[") ? path2 + key2 : path2 + "." + key2;
            }
            if ((value = entry.getValue()) instanceof String) {
                result.put(key2, value);
                continue;
            }
            if (value instanceof Map) {
                Map map2 = (Map)value;
                this.buildFlattenedMap(result, map2, key2);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                int count2 = 0;
                for (Object object : collection) {
                    this.buildFlattenedMap(result, Collections.singletonMap("[" + count2++ + "]", object), key2);
                }
                continue;
            }
            result.put(key2, value == null ? "" : value);
        }
    }

    protected static class StrictMapAppenderConstructor
    extends Constructor {
        protected Map<Object, Object> constructMapping(MappingNode node2) {
            try {
                return super.constructMapping(node2);
            }
            catch (IllegalStateException e2) {
                throw new ParserException("while parsing MappingNode", node2.getStartMark(), e2.getMessage(), node2.getEndMark());
            }
        }

        protected Map<Object, Object> createDefaultMap() {
            final Map delegate = super.createDefaultMap();
            return new AbstractMap<Object, Object>(){

                @Override
                public Object put(Object key2, Object value) {
                    if (delegate.containsKey(key2)) {
                        throw new IllegalStateException("duplicate key: " + key2);
                    }
                    return delegate.put(key2, value);
                }

                @Override
                public Set<Map.Entry<Object, Object>> entrySet() {
                    return delegate.entrySet();
                }
            };
        }
    }

    public static enum ResolutionMethod {
        OVERRIDE,
        OVERRIDE_AND_IGNORE,
        FIRST_FOUND;

    }

    public static enum MatchStatus {
        FOUND,
        NOT_FOUND,
        ABSTAIN;


        public static MatchStatus getMostSpecific(MatchStatus a, MatchStatus b) {
            return a.ordinal() < b.ordinal() ? a : b;
        }
    }

    public static interface DocumentMatcher {
        public MatchStatus matches(Properties var1);
    }

    public static interface MatchCallback {
        public void process(Properties var1, Map<String, Object> var2);
    }
}

