/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.parsing;

import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.parsing.AbstractComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.util.Assert;

public class CompositeComponentDefinition
extends AbstractComponentDefinition {
    private final String name;
    private final Object source;
    private final List<ComponentDefinition> nestedComponents = new LinkedList<ComponentDefinition>();

    public CompositeComponentDefinition(String name2, Object source2) {
        Assert.notNull(name2, "Name must not be null");
        this.name = name2;
        this.source = source2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public void addNestedComponent(ComponentDefinition component) {
        Assert.notNull(component, "ComponentDefinition must not be null");
        this.nestedComponents.add(component);
    }

    public ComponentDefinition[] getNestedComponents() {
        return this.nestedComponents.toArray(new ComponentDefinition[this.nestedComponents.size()]);
    }
}

