/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Method;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.util.ClassUtils;

public class GenericTypeAwareAutowireCandidateResolver
implements AutowireCandidateResolver,
BeanFactoryAware {
    private BeanFactory beanFactory;

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected final BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    @Override
    public boolean isAutowireCandidate(BeanDefinitionHolder bdHolder, DependencyDescriptor descriptor2) {
        if (!bdHolder.getBeanDefinition().isAutowireCandidate()) {
            return false;
        }
        return descriptor2 == null || this.checkGenericTypeMatch(bdHolder, descriptor2);
    }

    protected boolean checkGenericTypeMatch(BeanDefinitionHolder bdHolder, DependencyDescriptor descriptor2) {
        RootBeanDefinition dbd;
        ResolvableType dependencyType = descriptor2.getResolvableType();
        if (dependencyType.getType() instanceof Class) {
            return true;
        }
        ResolvableType targetType = null;
        RootBeanDefinition rbd = null;
        if (bdHolder.getBeanDefinition() instanceof RootBeanDefinition) {
            rbd = (RootBeanDefinition)bdHolder.getBeanDefinition();
        }
        if (rbd != null && (targetType = this.getReturnTypeForFactoryMethod(rbd, descriptor2)) == null && (dbd = this.getResolvedDecoratedDefinition(rbd)) != null) {
            targetType = this.getReturnTypeForFactoryMethod(dbd, descriptor2);
        }
        if (targetType == null) {
            Class<?> beanClass;
            Class<?> beanType;
            if (this.beanFactory != null && (beanType = this.beanFactory.getType(bdHolder.getBeanName())) != null) {
                targetType = ResolvableType.forClass(ClassUtils.getUserClass(beanType));
            }
            if (targetType == null && rbd != null && rbd.hasBeanClass() && rbd.getFactoryMethodName() == null && !FactoryBean.class.isAssignableFrom(beanClass = rbd.getBeanClass())) {
                targetType = ResolvableType.forClass(ClassUtils.getUserClass(beanClass));
            }
        }
        if (targetType == null || descriptor2.fallbackMatchAllowed() && targetType.hasUnresolvableGenerics()) {
            return true;
        }
        return dependencyType.isAssignableFrom(targetType);
    }

    protected RootBeanDefinition getResolvedDecoratedDefinition(RootBeanDefinition rbd) {
        BeanDefinition dbd;
        ConfigurableListableBeanFactory clbf;
        BeanDefinitionHolder decDef = rbd.getDecoratedDefinition();
        if (decDef != null && this.beanFactory instanceof ConfigurableListableBeanFactory && (clbf = (ConfigurableListableBeanFactory)this.beanFactory).containsBeanDefinition(decDef.getBeanName()) && (dbd = clbf.getMergedBeanDefinition(decDef.getBeanName())) instanceof RootBeanDefinition) {
            return (RootBeanDefinition)dbd;
        }
        return null;
    }

    protected ResolvableType getReturnTypeForFactoryMethod(RootBeanDefinition rbd, DependencyDescriptor descriptor2) {
        Class<?> preResolved = rbd.resolvedFactoryMethodReturnType;
        if (preResolved != null) {
            return ResolvableType.forClass(preResolved);
        }
        Method resolvedFactoryMethod = rbd.getResolvedFactoryMethod();
        if (resolvedFactoryMethod != null && descriptor2.getDependencyType().isAssignableFrom(resolvedFactoryMethod.getReturnType())) {
            return ResolvableType.forMethodReturnType(resolvedFactoryMethod);
        }
        return null;
    }

    @Override
    public Object getSuggestedValue(DependencyDescriptor descriptor2) {
        return null;
    }

    @Override
    public Object getLazyResolutionProxyIfNecessary(DependencyDescriptor descriptor2, String beanName) {
        return null;
    }
}

