/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.concurrent;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.util.Assert;

public class ConcurrentMapCache
implements Cache {
    private static final Object NULL_HOLDER = new NullHolder();
    private final String name;
    private final ConcurrentMap<Object, Object> store;
    private final boolean allowNullValues;

    public ConcurrentMapCache(String name2) {
        this(name2, new ConcurrentHashMap<Object, Object>(256), true);
    }

    public ConcurrentMapCache(String name2, boolean allowNullValues) {
        this(name2, new ConcurrentHashMap<Object, Object>(256), allowNullValues);
    }

    public ConcurrentMapCache(String name2, ConcurrentMap<Object, Object> store, boolean allowNullValues) {
        Assert.notNull(name2, "Name must not be null");
        Assert.notNull(store, "Store must not be null");
        this.name = name2;
        this.store = store;
        this.allowNullValues = allowNullValues;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final ConcurrentMap<Object, Object> getNativeCache() {
        return this.store;
    }

    public final boolean isAllowNullValues() {
        return this.allowNullValues;
    }

    @Override
    public Cache.ValueWrapper get(Object key2) {
        Object value = this.store.get(key2);
        return this.toWrapper(value);
    }

    @Override
    public <T> T get(Object key2, Class<T> type2) {
        Object value = this.fromStoreValue(this.store.get(key2));
        if (value != null && type2 != null && !type2.isInstance(value)) {
            throw new IllegalStateException("Cached value is not of required type [" + type2.getName() + "]: " + value);
        }
        return (T)value;
    }

    @Override
    public void put(Object key2, Object value) {
        this.store.put(key2, this.toStoreValue(value));
    }

    @Override
    public Cache.ValueWrapper putIfAbsent(Object key2, Object value) {
        Object existing = this.store.putIfAbsent(key2, value);
        return this.toWrapper(existing);
    }

    @Override
    public void evict(Object key2) {
        this.store.remove(key2);
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    protected Object fromStoreValue(Object storeValue) {
        if (this.allowNullValues && storeValue == NULL_HOLDER) {
            return null;
        }
        return storeValue;
    }

    protected Object toStoreValue(Object userValue) {
        if (this.allowNullValues && userValue == null) {
            return NULL_HOLDER;
        }
        return userValue;
    }

    private Cache.ValueWrapper toWrapper(Object value) {
        return value != null ? new SimpleValueWrapper(this.fromStoreValue(value)) : null;
    }

    private static class NullHolder
    implements Serializable {
        private NullHolder() {
        }
    }
}

