/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.support;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class NoOpCacheManager
implements CacheManager {
    private final ConcurrentMap<String, Cache> caches = new ConcurrentHashMap<String, Cache>(16);
    private final Set<String> cacheNames = new LinkedHashSet<String>(16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cache getCache(String name2) {
        Cache cache = (Cache)this.caches.get(name2);
        if (cache == null) {
            this.caches.putIfAbsent(name2, new NoOpCache(name2));
            Set<String> set2 = this.cacheNames;
            synchronized (set2) {
                this.cacheNames.add(name2);
            }
        }
        return (Cache)this.caches.get(name2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getCacheNames() {
        Set<String> set2 = this.cacheNames;
        synchronized (set2) {
            return Collections.unmodifiableSet(this.cacheNames);
        }
    }

    private static class NoOpCache
    implements Cache {
        private final String name;

        public NoOpCache(String name2) {
            this.name = name2;
        }

        @Override
        public void clear() {
        }

        @Override
        public void evict(Object key2) {
        }

        @Override
        public Cache.ValueWrapper get(Object key2) {
            return null;
        }

        @Override
        public <T> T get(Object key2, Class<T> type2) {
            return null;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object getNativeCache() {
            return null;
        }

        @Override
        public void put(Object key2, Object value) {
        }

        @Override
        public Cache.ValueWrapper putIfAbsent(Object key2, Object value) {
            return null;
        }
    }
}

