/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.beans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.springframework.asm.ClassVisitor;
import org.springframework.cglib.beans.BeanMapEmitter;
import org.springframework.cglib.core.AbstractClassGenerator;
import org.springframework.cglib.core.KeyFactory;
import org.springframework.cglib.core.ReflectUtils;

public abstract class BeanMap
implements Map {
    public static final int REQUIRE_GETTER = 1;
    public static final int REQUIRE_SETTER = 2;
    protected Object bean;
    static /* synthetic */ Class class$net$sf$cglib$beans$BeanMap;
    static /* synthetic */ Class class$net$sf$cglib$beans$BeanMap$Generator$BeanMapKey;

    public static BeanMap create(Object bean2) {
        Generator gen = new Generator();
        gen.setBean(bean2);
        return gen.create();
    }

    public abstract BeanMap newInstance(Object var1);

    public abstract Class getPropertyType(String var1);

    protected BeanMap() {
    }

    protected BeanMap(Object bean2) {
        this.setBean(bean2);
    }

    public Object get(Object key2) {
        return this.get(this.bean, key2);
    }

    public Object put(Object key2, Object value) {
        return this.put(this.bean, key2, value);
    }

    public abstract Object get(Object var1, Object var2);

    public abstract Object put(Object var1, Object var2, Object var3);

    public void setBean(Object bean2) {
        this.bean = bean2;
    }

    public Object getBean() {
        return this.bean;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean containsKey(Object key2) {
        return this.keySet().contains(key2);
    }

    public boolean containsValue(Object value) {
        Iterator it = this.keySet().iterator();
        while (it.hasNext()) {
            Object v = this.get(it.next());
            if ((value != null || v != null) && !value.equals(v)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.keySet().size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object remove(Object key2) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map t) {
        Iterator it = t.keySet().iterator();
        while (it.hasNext()) {
            Object key2 = it.next();
            this.put(key2, t.get(key2));
        }
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Map)) {
            return false;
        }
        Map other = (Map)o;
        if (this.size() != other.size()) {
            return false;
        }
        Iterator it = this.keySet().iterator();
        while (it.hasNext()) {
            Object key2 = it.next();
            if (!other.containsKey(key2)) {
                return false;
            }
            Object v1 = this.get(key2);
            Object v2 = other.get(key2);
            if (v1 != null ? v1.equals(v2) : v2 == null) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int code = 0;
        Iterator it = this.keySet().iterator();
        while (it.hasNext()) {
            Object key2 = it.next();
            Object value = this.get(key2);
            code += (key2 == null ? 0 : key2.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }
        return code;
    }

    public Set entrySet() {
        HashMap copy2 = new HashMap();
        Iterator it = this.keySet().iterator();
        while (it.hasNext()) {
            Object key2 = it.next();
            copy2.put(key2, this.get(key2));
        }
        return Collections.unmodifiableMap(copy2).entrySet();
    }

    public Collection values() {
        Set keys2 = this.keySet();
        ArrayList<Object> values = new ArrayList<Object>(keys2.size());
        Iterator it = keys2.iterator();
        while (it.hasNext()) {
            values.add(this.get(it.next()));
        }
        return Collections.unmodifiableCollection(values);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        Iterator it = this.keySet().iterator();
        while (it.hasNext()) {
            Object key2 = it.next();
            sb.append(key2);
            sb.append('=');
            sb.append(this.get(key2));
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append('}');
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Generator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source((class$net$sf$cglib$beans$BeanMap == null ? (class$net$sf$cglib$beans$BeanMap = BeanMap.class$("org.springframework.cglib.beans.BeanMap")) : class$net$sf$cglib$beans$BeanMap).getName());
        private static final BeanMapKey KEY_FACTORY = (BeanMapKey)((Object)KeyFactory.create(class$net$sf$cglib$beans$BeanMap$Generator$BeanMapKey == null ? (class$net$sf$cglib$beans$BeanMap$Generator$BeanMapKey = BeanMap.class$("org.springframework.cglib.beans.BeanMap$Generator$BeanMapKey")) : class$net$sf$cglib$beans$BeanMap$Generator$BeanMapKey, KeyFactory.CLASS_BY_NAME));
        private Object bean;
        private Class beanClass;
        private int require;

        public Generator() {
            super(SOURCE);
        }

        public void setBean(Object bean2) {
            this.bean = bean2;
            if (bean2 != null) {
                this.beanClass = bean2.getClass();
            }
        }

        public void setBeanClass(Class beanClass) {
            this.beanClass = beanClass;
        }

        public void setRequire(int require2) {
            this.require = require2;
        }

        protected ClassLoader getDefaultClassLoader() {
            return this.beanClass.getClassLoader();
        }

        public BeanMap create() {
            if (this.beanClass == null) {
                throw new IllegalArgumentException("Class of bean unknown");
            }
            this.setNamePrefix(this.beanClass.getName());
            return (BeanMap)super.create(KEY_FACTORY.newInstance(this.beanClass, this.require));
        }

        public void generateClass(ClassVisitor v) throws Exception {
            new BeanMapEmitter(v, this.getClassName(), this.beanClass, this.require);
        }

        protected Object firstInstance(Class type2) {
            return ((BeanMap)ReflectUtils.newInstance(type2)).newInstance(this.bean);
        }

        protected Object nextInstance(Object instance) {
            return ((BeanMap)instance).newInstance(this.bean);
        }

        static interface BeanMapKey {
            public Object newInstance(Class var1, int var2);
        }
    }
}

