/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.transform.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springframework.asm.Type;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.CodeGenerationException;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;
import org.springframework.cglib.transform.ClassEmitterTransformer;

public class AddDelegateTransformer
extends ClassEmitterTransformer {
    private static final String DELEGATE = "$CGLIB_DELEGATE";
    private static final Signature CSTRUCT_OBJECT = TypeUtils.parseSignature("void <init>(Object)");
    private Class[] delegateIf;
    private Class delegateImpl;
    private Type delegateType;
    static /* synthetic */ Class class$java$lang$Object;

    public AddDelegateTransformer(Class[] delegateIf, Class delegateImpl) {
        try {
            delegateImpl.getConstructor(class$java$lang$Object == null ? (class$java$lang$Object = AddDelegateTransformer.class$("java.lang.Object")) : class$java$lang$Object);
            this.delegateIf = delegateIf;
            this.delegateImpl = delegateImpl;
            this.delegateType = Type.getType(delegateImpl);
        }
        catch (NoSuchMethodException e2) {
            throw new CodeGenerationException(e2);
        }
    }

    public void begin_class(int version, int access, String className, Type superType, Type[] interfaces, String sourceFile) {
        if (!TypeUtils.isInterface(access)) {
            Type[] all = TypeUtils.add(interfaces, TypeUtils.getTypes(this.delegateIf));
            super.begin_class(version, access, className, superType, all, sourceFile);
            this.declare_field(130, DELEGATE, this.delegateType, null);
            for (int i = 0; i < this.delegateIf.length; ++i) {
                Method[] methods2 = this.delegateIf[i].getMethods();
                for (int j = 0; j < methods2.length; ++j) {
                    if (!Modifier.isAbstract(methods2[j].getModifiers())) continue;
                    this.addDelegate(methods2[j]);
                }
            }
        } else {
            super.begin_class(version, access, className, superType, interfaces, sourceFile);
        }
    }

    public CodeEmitter begin_method(int access, Signature sig, Type[] exceptions) {
        CodeEmitter e2 = super.begin_method(access, sig, exceptions);
        if (sig.getName().equals("<init>")) {
            return new CodeEmitter(e2){
                private boolean transformInit = true;

                public void visitMethodInsn(int opcode, String owner, String name2, String desc) {
                    super.visitMethodInsn(opcode, owner, name2, desc);
                    if (this.transformInit && opcode == 183) {
                        this.load_this();
                        this.new_instance(AddDelegateTransformer.this.delegateType);
                        this.dup();
                        this.load_this();
                        this.invoke_constructor(AddDelegateTransformer.this.delegateType, CSTRUCT_OBJECT);
                        this.putfield(AddDelegateTransformer.DELEGATE);
                        this.transformInit = false;
                    }
                }
            };
        }
        return e2;
    }

    private void addDelegate(Method m) {
        try {
            Method delegate = this.delegateImpl.getMethod(m.getName(), m.getParameterTypes());
            if (!delegate.getReturnType().getName().equals(m.getReturnType().getName())) {
                throw new IllegalArgumentException("Invalid delegate signature " + delegate);
            }
        }
        catch (NoSuchMethodException e2) {
            throw new CodeGenerationException(e2);
        }
        Signature sig = ReflectUtils.getSignature(m);
        Type[] exceptions = TypeUtils.getTypes(m.getExceptionTypes());
        CodeEmitter e3 = super.begin_method(1, sig, exceptions);
        e3.load_this();
        e3.getfield(DELEGATE);
        e3.load_args();
        e3.invoke_virtual(this.delegateType, sig);
        e3.return_value();
        e3.end_method();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

