/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.expression;

import java.util.Map;
import org.springframework.context.expression.AnnotatedElementKey;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class CachedExpressionEvaluator {
    private final SpelExpressionParser parser;

    protected CachedExpressionEvaluator(SpelExpressionParser parser) {
        Assert.notNull(parser, "Parser must not be null");
        this.parser = parser;
    }

    protected CachedExpressionEvaluator() {
        this(new SpelExpressionParser());
    }

    protected SpelExpressionParser getParser() {
        return this.parser;
    }

    protected Expression getExpression(Map<ExpressionKey, Expression> cache, AnnotatedElementKey elementKey, String expression) {
        ExpressionKey expressionKey = this.createKey(elementKey, expression);
        Expression expr = cache.get(expressionKey);
        if (expr == null) {
            expr = this.getParser().parseExpression(expression);
            cache.put(expressionKey, expr);
        }
        return expr;
    }

    private ExpressionKey createKey(AnnotatedElementKey elementKey, String expression) {
        return new ExpressionKey(elementKey, expression);
    }

    protected static class ExpressionKey {
        private final AnnotatedElementKey key;
        private final String expression;

        protected ExpressionKey(AnnotatedElementKey key2, String expression) {
            this.key = key2;
            this.expression = expression;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExpressionKey)) {
                return false;
            }
            ExpressionKey otherKey = (ExpressionKey)other;
            return this.key.equals(otherKey.key) && ObjectUtils.nullSafeEquals(this.expression, otherKey.expression);
        }

        public int hashCode() {
            return this.key.hashCode() * 29 + (this.expression != null ? this.expression.hashCode() : 0);
        }
    }
}

