/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.expression;

import java.lang.reflect.Method;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.ObjectUtils;

public class MethodBasedEvaluationContext
extends StandardEvaluationContext {
    private final Method method;
    private final Object[] args;
    private final ParameterNameDiscoverer paramDiscoverer;
    private boolean paramLoaded = false;

    public MethodBasedEvaluationContext(Object rootObject, Method method, Object[] args, ParameterNameDiscoverer paramDiscoverer) {
        super(rootObject);
        this.method = method;
        this.args = args;
        this.paramDiscoverer = paramDiscoverer;
    }

    @Override
    public Object lookupVariable(String name2) {
        Object variable = super.lookupVariable(name2);
        if (variable != null) {
            return variable;
        }
        if (!this.paramLoaded) {
            this.lazyLoadArguments();
            this.paramLoaded = true;
            variable = super.lookupVariable(name2);
        }
        return variable;
    }

    protected void lazyLoadArguments() {
        if (ObjectUtils.isEmpty(this.args)) {
            return;
        }
        for (int i = 0; i < this.args.length; ++i) {
            this.setVariable("a" + i, this.args[i]);
            this.setVariable("p" + i, this.args[i]);
        }
        String[] parameterNames = this.paramDiscoverer.getParameterNames(this.method);
        if (parameterNames != null) {
            for (int i = 0; i < parameterNames.length; ++i) {
                this.setVariable(parameterNames[i], this.args[i]);
            }
        }
    }
}

