/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.Aware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.util.StringValueResolver;

class ApplicationContextAwareProcessor
implements BeanPostProcessor {
    private final ConfigurableApplicationContext applicationContext;

    public ApplicationContextAwareProcessor(ConfigurableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public Object postProcessBeforeInitialization(final Object bean2, String beanName) throws BeansException {
        AccessControlContext acc = null;
        if (System.getSecurityManager() != null && (bean2 instanceof EnvironmentAware || bean2 instanceof EmbeddedValueResolverAware || bean2 instanceof ResourceLoaderAware || bean2 instanceof ApplicationEventPublisherAware || bean2 instanceof MessageSourceAware || bean2 instanceof ApplicationContextAware)) {
            acc = this.applicationContext.getBeanFactory().getAccessControlContext();
        }
        if (acc != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ApplicationContextAwareProcessor.this.invokeAwareInterfaces(bean2);
                    return null;
                }
            }, acc);
        } else {
            this.invokeAwareInterfaces(bean2);
        }
        return bean2;
    }

    private void invokeAwareInterfaces(Object bean2) {
        if (bean2 instanceof Aware) {
            if (bean2 instanceof EnvironmentAware) {
                ((EnvironmentAware)bean2).setEnvironment(this.applicationContext.getEnvironment());
            }
            if (bean2 instanceof EmbeddedValueResolverAware) {
                ((EmbeddedValueResolverAware)bean2).setEmbeddedValueResolver(new EmbeddedValueResolver(this.applicationContext.getBeanFactory()));
            }
            if (bean2 instanceof ResourceLoaderAware) {
                ((ResourceLoaderAware)bean2).setResourceLoader(this.applicationContext);
            }
            if (bean2 instanceof ApplicationEventPublisherAware) {
                ((ApplicationEventPublisherAware)bean2).setApplicationEventPublisher(this.applicationContext);
            }
            if (bean2 instanceof MessageSourceAware) {
                ((MessageSourceAware)bean2).setMessageSource(this.applicationContext);
            }
            if (bean2 instanceof ApplicationContextAware) {
                ((ApplicationContextAware)bean2).setApplicationContext(this.applicationContext);
            }
        }
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String beanName) {
        return bean2;
    }

    private static class EmbeddedValueResolver
    implements StringValueResolver {
        private final ConfigurableBeanFactory beanFactory;

        public EmbeddedValueResolver(ConfigurableBeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        @Override
        public String resolveStringValue(String strVal) {
            return this.beanFactory.resolveEmbeddedValue(strVal);
        }
    }
}

