/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.DecoratingClassLoader;
import org.springframework.core.OverridingClassLoader;
import org.springframework.core.SmartClassLoader;
import org.springframework.lang.UsesJava7;
import org.springframework.util.ReflectionUtils;

@UsesJava7
class ContextTypeMatchClassLoader
extends DecoratingClassLoader
implements SmartClassLoader {
    private static Method findLoadedClassMethod;
    private final Map<String, byte[]> bytesCache = new ConcurrentHashMap<String, byte[]>(256);

    public ContextTypeMatchClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    public Class<?> loadClass(String name2) throws ClassNotFoundException {
        return new ContextOverridingClassLoader(this.getParent()).loadClass(name2);
    }

    @Override
    public boolean isClassReloadable(Class<?> clazz) {
        return clazz.getClassLoader() instanceof ContextOverridingClassLoader;
    }

    static {
        if (parallelCapableClassLoaderAvailable) {
            ClassLoader.registerAsParallelCapable();
        }
        try {
            findLoadedClassMethod = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("Invalid [java.lang.ClassLoader] class: no 'findLoadedClass' method defined!");
        }
    }

    private class ContextOverridingClassLoader
    extends OverridingClassLoader {
        public ContextOverridingClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        protected boolean isEligibleForOverriding(String className) {
            if (this.isExcluded(className) || ContextTypeMatchClassLoader.this.isExcluded(className)) {
                return false;
            }
            ReflectionUtils.makeAccessible(findLoadedClassMethod);
            for (ClassLoader parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (ReflectionUtils.invokeMethod(findLoadedClassMethod, parent, className) == null) continue;
                return false;
            }
            return true;
        }

        @Override
        protected Class<?> loadClassForOverriding(String name2) throws ClassNotFoundException {
            byte[] bytes2 = (byte[])ContextTypeMatchClassLoader.this.bytesCache.get(name2);
            if (bytes2 == null) {
                bytes2 = this.loadBytesForClass(name2);
                if (bytes2 != null) {
                    ContextTypeMatchClassLoader.this.bytesCache.put(name2, bytes2);
                } else {
                    return null;
                }
            }
            return this.defineClass(name2, bytes2, 0, bytes2.length);
        }
    }
}

