/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;

public abstract class GenericTypeResolver {
    private static final Map<Class<?>, Map<TypeVariable, Type>> typeVariableCache = new ConcurrentReferenceHashMap();

    @Deprecated
    public static Type getTargetType(MethodParameter methodParam) {
        Assert.notNull(methodParam, "MethodParameter must not be null");
        return methodParam.getGenericParameterType();
    }

    public static Class<?> resolveParameterType(MethodParameter methodParam, Class<?> clazz) {
        Assert.notNull(methodParam, "MethodParameter must not be null");
        Assert.notNull(clazz, "Class must not be null");
        methodParam.setContainingClass(clazz);
        methodParam.setParameterType(ResolvableType.forMethodParameter(methodParam).resolve());
        return methodParam.getParameterType();
    }

    public static Class<?> resolveReturnType(Method method, Class<?> clazz) {
        Assert.notNull(method, "Method must not be null");
        Assert.notNull(clazz, "Class must not be null");
        return ResolvableType.forMethodReturnType(method, clazz).resolve(method.getReturnType());
    }

    public static Class<?> resolveReturnTypeForGenericMethod(Method method, Object[] args, ClassLoader classLoader) {
        Assert.notNull(method, "Method must not be null");
        Assert.notNull(args, "Argument array must not be null");
        TypeVariable<Method>[] declaredTypeVariables = method.getTypeParameters();
        Type genericReturnType = method.getGenericReturnType();
        Type[] methodArgumentTypes = method.getGenericParameterTypes();
        if (declaredTypeVariables.length == 0) {
            return method.getReturnType();
        }
        if (args.length < methodArgumentTypes.length) {
            return null;
        }
        boolean locallyDeclaredTypeVariableMatchesReturnType = false;
        for (TypeVariable<Method> currentTypeVariable : declaredTypeVariables) {
            if (!currentTypeVariable.equals(genericReturnType)) continue;
            locallyDeclaredTypeVariableMatchesReturnType = true;
            break;
        }
        if (locallyDeclaredTypeVariableMatchesReturnType) {
            for (int i = 0; i < methodArgumentTypes.length; ++i) {
                Type[] actualTypeArguments;
                Type currentMethodArgumentType = methodArgumentTypes[i];
                if (currentMethodArgumentType.equals(genericReturnType)) {
                    return args[i].getClass();
                }
                if (!(currentMethodArgumentType instanceof ParameterizedType)) continue;
                ParameterizedType parameterizedType = (ParameterizedType)currentMethodArgumentType;
                for (Type typeArg : actualTypeArguments = parameterizedType.getActualTypeArguments()) {
                    if (!typeArg.equals(genericReturnType)) continue;
                    Object arg = args[i];
                    if (arg instanceof Class) {
                        return (Class)arg;
                    }
                    if (arg instanceof String && classLoader != null) {
                        try {
                            return classLoader.loadClass((String)arg);
                        }
                        catch (ClassNotFoundException ex) {
                            throw new IllegalStateException("Could not resolve specific class name argument [" + arg + "]", ex);
                        }
                    }
                    return method.getReturnType();
                }
            }
        }
        return method.getReturnType();
    }

    public static Class<?> resolveReturnTypeArgument(Method method, Class<?> genericIfc) {
        Assert.notNull(method, "method must not be null");
        ResolvableType resolvableType = ResolvableType.forMethodReturnType(method).as(genericIfc);
        if (!resolvableType.hasGenerics() || resolvableType.getType() instanceof WildcardType) {
            return null;
        }
        return GenericTypeResolver.getSingleGeneric(resolvableType);
    }

    public static Class<?> resolveTypeArgument(Class<?> clazz, Class<?> genericIfc) {
        ResolvableType resolvableType = ResolvableType.forClass(clazz).as(genericIfc);
        if (!resolvableType.hasGenerics()) {
            return null;
        }
        return GenericTypeResolver.getSingleGeneric(resolvableType);
    }

    private static Class<?> getSingleGeneric(ResolvableType resolvableType) {
        if (resolvableType.getGenerics().length > 1) {
            throw new IllegalArgumentException("Expected 1 type argument on generic interface [" + resolvableType + "] but found " + resolvableType.getGenerics().length);
        }
        return resolvableType.getGeneric(new int[0]).resolve();
    }

    public static Class<?>[] resolveTypeArguments(Class<?> clazz, Class<?> genericIfc) {
        ResolvableType type2 = ResolvableType.forClass(clazz).as(genericIfc);
        if (!type2.hasGenerics() || type2.isEntirelyUnresolvable()) {
            return null;
        }
        return type2.resolveGenerics(Object.class);
    }

    @Deprecated
    public static Class<?> resolveType(Type genericType, Map<TypeVariable, Type> map2) {
        return ResolvableType.forType(genericType, new TypeVariableMapVariableResolver(map2)).resolve(Object.class);
    }

    @Deprecated
    public static Map<TypeVariable, Type> getTypeVariableMap(Class<?> clazz) {
        Map<TypeVariable, Type> typeVariableMap = typeVariableCache.get(clazz);
        if (typeVariableMap == null) {
            typeVariableMap = new HashMap<TypeVariable, Type>();
            GenericTypeResolver.buildTypeVariableMap(ResolvableType.forClass(clazz), typeVariableMap);
            typeVariableCache.put(clazz, Collections.unmodifiableMap(typeVariableMap));
        }
        return typeVariableMap;
    }

    private static void buildTypeVariableMap(ResolvableType type2, Map<TypeVariable, Type> typeVariableMap) {
        if (type2 != ResolvableType.NONE) {
            if (type2.getType() instanceof ParameterizedType) {
                TypeVariable<Class<?>>[] variables = type2.resolve().getTypeParameters();
                for (int i = 0; i < variables.length; ++i) {
                    ResolvableType generic = type2.getGeneric(i);
                    while (generic.getType() instanceof TypeVariable) {
                        generic = generic.resolveType();
                    }
                    if (generic == ResolvableType.NONE) continue;
                    typeVariableMap.put(variables[i], generic.getType());
                }
            }
            GenericTypeResolver.buildTypeVariableMap(type2.getSuperType(), typeVariableMap);
            for (ResolvableType interfaceType : type2.getInterfaces()) {
                GenericTypeResolver.buildTypeVariableMap(interfaceType, typeVariableMap);
            }
            if (type2.resolve().isMemberClass()) {
                GenericTypeResolver.buildTypeVariableMap(ResolvableType.forClass(type2.resolve().getEnclosingClass()), typeVariableMap);
            }
        }
    }

    private static class TypeVariableMapVariableResolver
    implements ResolvableType.VariableResolver {
        private final Map<TypeVariable, Type> typeVariableMap;

        public TypeVariableMapVariableResolver(Map<TypeVariable, Type> typeVariableMap) {
            this.typeVariableMap = typeVariableMap;
        }

        @Override
        public ResolvableType resolveVariable(TypeVariable<?> variable) {
            Type type2 = this.typeVariableMap.get(variable);
            return type2 != null ? ResolvableType.forType(type2) : null;
        }

        @Override
        public Object getSource() {
            return this.typeVariableMap;
        }
    }
}

