/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.annotation.AnnotationAttributeExtractor;
import org.springframework.core.annotation.AnnotationConfigurationException;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

class SynthesizedAnnotationInvocationHandler
implements InvocationHandler {
    private final AnnotationAttributeExtractor attributeExtractor;
    private final Map<String, Object> valueCache = new ConcurrentHashMap<String, Object>(8);

    SynthesizedAnnotationInvocationHandler(AnnotationAttributeExtractor attributeExtractor) {
        Assert.notNull(attributeExtractor, "AnnotationAttributeExtractor must not be null");
        this.attributeExtractor = attributeExtractor;
    }

    @Override
    public Object invoke(Object proxy2, Method method, Object[] args) throws Throwable {
        if (ReflectionUtils.isEqualsMethod(method)) {
            return this.annotationEquals(args[0]);
        }
        if (ReflectionUtils.isHashCodeMethod(method)) {
            return this.annotationHashCode();
        }
        if (ReflectionUtils.isToStringMethod(method)) {
            return this.annotationToString();
        }
        if (AnnotationUtils.isAnnotationTypeMethod(method)) {
            return this.annotationType();
        }
        if (!AnnotationUtils.isAttributeMethod(method)) {
            String msg = String.format("Method [%s] is unsupported for synthesized annotation type [%s]", method, this.annotationType());
            throw new AnnotationConfigurationException(msg);
        }
        return this.getAttributeValue(method);
    }

    private Class<? extends Annotation> annotationType() {
        return this.attributeExtractor.getAnnotationType();
    }

    private Object getAttributeValue(Method attributeMethod) {
        String attributeName = attributeMethod.getName();
        Object value = this.valueCache.get(attributeName);
        if (value == null) {
            value = this.attributeExtractor.getAttributeValue(attributeMethod);
            if (value == null) {
                throw new IllegalStateException(String.format("%s returned null for attribute name [%s] from attribute source [%s]", this.attributeExtractor.getClass().getName(), attributeName, this.attributeExtractor.getSource()));
            }
            if (value instanceof Annotation) {
                value = AnnotationUtils.synthesizeAnnotation((Annotation)value, this.attributeExtractor.getAnnotatedElement());
            } else if (value instanceof Annotation[]) {
                value = AnnotationUtils.synthesizeAnnotationArray(value, this.attributeExtractor.getAnnotatedElement());
            }
            this.valueCache.put(attributeName, value);
        }
        if (value.getClass().isArray()) {
            value = this.cloneArray(value);
        }
        return value;
    }

    private Object cloneArray(Object array2) {
        if (array2 instanceof boolean[]) {
            return ((boolean[])array2).clone();
        }
        if (array2 instanceof byte[]) {
            return ((byte[])array2).clone();
        }
        if (array2 instanceof char[]) {
            return ((char[])array2).clone();
        }
        if (array2 instanceof double[]) {
            return ((double[])array2).clone();
        }
        if (array2 instanceof float[]) {
            return ((float[])array2).clone();
        }
        if (array2 instanceof int[]) {
            return ((int[])array2).clone();
        }
        if (array2 instanceof long[]) {
            return ((long[])array2).clone();
        }
        if (array2 instanceof short[]) {
            return ((short[])array2).clone();
        }
        return ((Object[])array2).clone();
    }

    private boolean annotationEquals(Object other) {
        if (this == other) {
            return true;
        }
        if (!this.annotationType().isInstance(other)) {
            return false;
        }
        for (Method attributeMethod : AnnotationUtils.getAttributeMethods(this.annotationType())) {
            Object otherValue;
            Object thisValue = this.getAttributeValue(attributeMethod);
            if (ObjectUtils.nullSafeEquals(thisValue, otherValue = ReflectionUtils.invokeMethod(attributeMethod, other))) continue;
            return false;
        }
        return true;
    }

    private int annotationHashCode() {
        int result = 0;
        for (Method attributeMethod : AnnotationUtils.getAttributeMethods(this.annotationType())) {
            Object value = this.getAttributeValue(attributeMethod);
            int hashCode = value.getClass().isArray() ? this.hashCodeForArray(value) : value.hashCode();
            result += 127 * attributeMethod.getName().hashCode() ^ hashCode;
        }
        return result;
    }

    private int hashCodeForArray(Object array2) {
        if (array2 instanceof boolean[]) {
            return Arrays.hashCode((boolean[])array2);
        }
        if (array2 instanceof byte[]) {
            return Arrays.hashCode((byte[])array2);
        }
        if (array2 instanceof char[]) {
            return Arrays.hashCode((char[])array2);
        }
        if (array2 instanceof double[]) {
            return Arrays.hashCode((double[])array2);
        }
        if (array2 instanceof float[]) {
            return Arrays.hashCode((float[])array2);
        }
        if (array2 instanceof int[]) {
            return Arrays.hashCode((int[])array2);
        }
        if (array2 instanceof long[]) {
            return Arrays.hashCode((long[])array2);
        }
        if (array2 instanceof short[]) {
            return Arrays.hashCode((short[])array2);
        }
        return Arrays.hashCode((Object[])array2);
    }

    private String annotationToString() {
        StringBuilder sb = new StringBuilder("@").append(this.annotationType().getName()).append("(");
        Iterator<Method> iterator = AnnotationUtils.getAttributeMethods(this.annotationType()).iterator();
        while (iterator.hasNext()) {
            Method attributeMethod = iterator.next();
            sb.append(attributeMethod.getName());
            sb.append('=');
            sb.append(this.attributeValueToString(this.getAttributeValue(attributeMethod)));
            sb.append(iterator.hasNext() ? ", " : "");
        }
        return sb.append(")").toString();
    }

    private String attributeValueToString(Object value) {
        if (value instanceof Object[]) {
            return "[" + StringUtils.arrayToDelimitedString((Object[])value, ", ") + "]";
        }
        return String.valueOf(value);
    }
}

