/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.ConfigurablePropertyResolver;
import org.springframework.core.env.MissingRequiredPropertiesException;
import org.springframework.util.PropertyPlaceholderHelper;

public abstract class AbstractPropertyResolver
implements ConfigurablePropertyResolver {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected ConfigurableConversionService conversionService = new DefaultConversionService();
    private PropertyPlaceholderHelper nonStrictHelper;
    private PropertyPlaceholderHelper strictHelper;
    private boolean ignoreUnresolvableNestedPlaceholders = false;
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private String valueSeparator = ":";
    private final Set<String> requiredProperties = new LinkedHashSet<String>();

    @Override
    public ConfigurableConversionService getConversionService() {
        return this.conversionService;
    }

    @Override
    public void setConversionService(ConfigurableConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
    }

    @Override
    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
    }

    @Override
    public void setValueSeparator(String valueSeparator) {
        this.valueSeparator = valueSeparator;
    }

    @Override
    public void setIgnoreUnresolvableNestedPlaceholders(boolean ignoreUnresolvableNestedPlaceholders) {
        this.ignoreUnresolvableNestedPlaceholders = ignoreUnresolvableNestedPlaceholders;
    }

    @Override
    public void setRequiredProperties(String ... requiredProperties) {
        for (String key2 : requiredProperties) {
            this.requiredProperties.add(key2);
        }
    }

    @Override
    public void validateRequiredProperties() {
        MissingRequiredPropertiesException ex = new MissingRequiredPropertiesException();
        for (String key2 : this.requiredProperties) {
            if (this.getProperty(key2) != null) continue;
            ex.addMissingRequiredProperty(key2);
        }
        if (!ex.getMissingRequiredProperties().isEmpty()) {
            throw ex;
        }
    }

    @Override
    public String getProperty(String key2, String defaultValue) {
        String value = this.getProperty(key2);
        return value != null ? value : defaultValue;
    }

    @Override
    public <T> T getProperty(String key2, Class<T> targetType, T defaultValue) {
        T value = this.getProperty(key2, targetType);
        return value != null ? value : defaultValue;
    }

    @Override
    public String getRequiredProperty(String key2) throws IllegalStateException {
        String value = this.getProperty(key2);
        if (value == null) {
            throw new IllegalStateException(String.format("required key [%s] not found", key2));
        }
        return value;
    }

    @Override
    public <T> T getRequiredProperty(String key2, Class<T> valueType) throws IllegalStateException {
        T value = this.getProperty(key2, valueType);
        if (value == null) {
            throw new IllegalStateException(String.format("required key [%s] not found", key2));
        }
        return value;
    }

    @Override
    public String resolvePlaceholders(String text) {
        if (this.nonStrictHelper == null) {
            this.nonStrictHelper = this.createPlaceholderHelper(true);
        }
        return this.doResolvePlaceholders(text, this.nonStrictHelper);
    }

    @Override
    public String resolveRequiredPlaceholders(String text) throws IllegalArgumentException {
        if (this.strictHelper == null) {
            this.strictHelper = this.createPlaceholderHelper(false);
        }
        return this.doResolvePlaceholders(text, this.strictHelper);
    }

    protected String resolveNestedPlaceholders(String value) {
        return this.ignoreUnresolvableNestedPlaceholders ? this.resolvePlaceholders(value) : this.resolveRequiredPlaceholders(value);
    }

    private PropertyPlaceholderHelper createPlaceholderHelper(boolean ignoreUnresolvablePlaceholders) {
        return new PropertyPlaceholderHelper(this.placeholderPrefix, this.placeholderSuffix, this.valueSeparator, ignoreUnresolvablePlaceholders);
    }

    private String doResolvePlaceholders(String text, PropertyPlaceholderHelper helper) {
        return helper.replacePlaceholders(text, new PropertyPlaceholderHelper.PlaceholderResolver(){

            @Override
            public String resolvePlaceholder(String placeholderName) {
                return AbstractPropertyResolver.this.getPropertyAsRawString(placeholderName);
            }
        });
    }

    protected abstract String getPropertyAsRawString(String var1);
}

