/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class PropertySource<T> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final String name;
    protected final T source;

    public PropertySource(String name2, T source2) {
        Assert.hasText(name2, "Property source name must contain at least one character");
        Assert.notNull(source2, "Property source must not be null");
        this.name = name2;
        this.source = source2;
    }

    public PropertySource(String name2) {
        this(name2, new Object());
    }

    public String getName() {
        return this.name;
    }

    public T getSource() {
        return this.source;
    }

    public boolean containsProperty(String name2) {
        return this.getProperty(name2) != null;
    }

    public abstract Object getProperty(String var1);

    public boolean equals(Object obj) {
        return this == obj || obj instanceof PropertySource && ObjectUtils.nullSafeEquals(this.name, ((PropertySource)obj).name);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.name);
    }

    public String toString() {
        if (this.logger.isDebugEnabled()) {
            return String.format("%s@%s [name='%s', properties=%s]", this.getClass().getSimpleName(), System.identityHashCode(this), this.name, this.source);
        }
        return String.format("%s [name='%s']", this.getClass().getSimpleName(), this.name);
    }

    public static PropertySource<?> named(String name2) {
        return new ComparisonPropertySource(name2);
    }

    static class ComparisonPropertySource
    extends StubPropertySource {
        private static final String USAGE_ERROR = "ComparisonPropertySource instances are for use with collection comparison only";

        public ComparisonPropertySource(String name2) {
            super(name2);
        }

        @Override
        public Object getSource() {
            throw new UnsupportedOperationException(USAGE_ERROR);
        }

        @Override
        public boolean containsProperty(String name2) {
            throw new UnsupportedOperationException(USAGE_ERROR);
        }

        @Override
        public String getProperty(String name2) {
            throw new UnsupportedOperationException(USAGE_ERROR);
        }

        @Override
        public String toString() {
            return String.format("%s [name='%s']", this.getClass().getSimpleName(), this.name);
        }
    }

    public static class StubPropertySource
    extends PropertySource<Object> {
        public StubPropertySource(String name2) {
            super(name2, new Object());
        }

        @Override
        public String getProperty(String name2) {
            return null;
        }
    }
}

