/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import java.util.Map;
import org.springframework.core.env.MapPropertySource;
import org.springframework.util.Assert;

public class SystemEnvironmentPropertySource
extends MapPropertySource {
    public SystemEnvironmentPropertySource(String name2, Map<String, Object> source2) {
        super(name2, source2);
    }

    @Override
    public boolean containsProperty(String name2) {
        return this.getProperty(name2) != null;
    }

    @Override
    public Object getProperty(String name2) {
        String actualName = this.resolvePropertyName(name2);
        if (this.logger.isDebugEnabled() && !name2.equals(actualName)) {
            this.logger.debug(String.format("PropertySource [%s] does not contain '%s', but found equivalent '%s'", this.getName(), name2, actualName));
        }
        return super.getProperty(actualName);
    }

    private String resolvePropertyName(String name2) {
        Assert.notNull(name2, "Property name must not be null");
        if (this.containsKey(name2)) {
            return name2;
        }
        String usName = name2.replace('.', '_');
        if (!name2.equals(usName) && this.containsKey(usName)) {
            return usName;
        }
        String ucName = name2.toUpperCase();
        if (!name2.equals(ucName)) {
            if (this.containsKey(ucName)) {
                return ucName;
            }
            String usUcName = ucName.replace('.', '_');
            if (!ucName.equals(usUcName) && this.containsKey(usUcName)) {
                return usUcName;
            }
        }
        return name2;
    }

    private boolean containsKey(String name2) {
        return this.isSecurityManagerPresent() ? ((Map)this.source).keySet().contains(name2) : ((Map)this.source).containsKey(name2);
    }

    protected boolean isSecurityManagerPresent() {
        return System.getSecurityManager() != null;
    }
}

