/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.util.Locale;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;

public class LocalizedResourceHelper {
    public static final String DEFAULT_SEPARATOR = "_";
    private final ResourceLoader resourceLoader;
    private String separator = "_";

    public LocalizedResourceHelper() {
        this.resourceLoader = new DefaultResourceLoader();
    }

    public LocalizedResourceHelper(ResourceLoader resourceLoader) {
        Assert.notNull(resourceLoader, "ResourceLoader must not be null");
        this.resourceLoader = resourceLoader;
    }

    public void setSeparator(String separator) {
        this.separator = separator != null ? separator : DEFAULT_SEPARATOR;
    }

    public Resource findLocalizedResource(String name2, String extension, Locale locale) {
        Assert.notNull(name2, "Name must not be null");
        Assert.notNull(extension, "Extension must not be null");
        Resource resource2 = null;
        if (locale != null) {
            String location;
            String lang = locale.getLanguage();
            String country = locale.getCountry();
            String variant = locale.getVariant();
            if (variant.length() > 0) {
                location = name2 + this.separator + lang + this.separator + country + this.separator + variant + extension;
                resource2 = this.resourceLoader.getResource(location);
            }
            if (!(resource2 != null && resource2.exists() || country.length() <= 0)) {
                location = name2 + this.separator + lang + this.separator + country + extension;
                resource2 = this.resourceLoader.getResource(location);
            }
            if (!(resource2 != null && resource2.exists() || lang.length() <= 0)) {
                location = name2 + this.separator + lang + extension;
                resource2 = this.resourceLoader.getResource(location);
            }
        }
        if (resource2 == null || !resource2.exists()) {
            String location = name2 + extension;
            resource2 = this.resourceLoader.getResource(location);
        }
        return resource2;
    }
}

