/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.io.IOException;
import java.util.Map;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.StringUtils;

public class ResourcePropertySource
extends PropertiesPropertySource {
    private final String resourceName;

    public ResourcePropertySource(String name2, EncodedResource resource2) throws IOException {
        super(name2, PropertiesLoaderUtils.loadProperties(resource2));
        this.resourceName = ResourcePropertySource.getNameForResource(resource2.getResource());
    }

    public ResourcePropertySource(EncodedResource resource2) throws IOException {
        super(ResourcePropertySource.getNameForResource(resource2.getResource()), PropertiesLoaderUtils.loadProperties(resource2));
        this.resourceName = null;
    }

    public ResourcePropertySource(String name2, Resource resource2) throws IOException {
        super(name2, PropertiesLoaderUtils.loadProperties(new EncodedResource(resource2)));
        this.resourceName = ResourcePropertySource.getNameForResource(resource2);
    }

    public ResourcePropertySource(Resource resource2) throws IOException {
        super(ResourcePropertySource.getNameForResource(resource2), PropertiesLoaderUtils.loadProperties(new EncodedResource(resource2)));
        this.resourceName = null;
    }

    public ResourcePropertySource(String name2, String location, ClassLoader classLoader) throws IOException {
        this(name2, new DefaultResourceLoader(classLoader).getResource(location));
    }

    public ResourcePropertySource(String location, ClassLoader classLoader) throws IOException {
        this(new DefaultResourceLoader(classLoader).getResource(location));
    }

    public ResourcePropertySource(String name2, String location) throws IOException {
        this(name2, new DefaultResourceLoader().getResource(location));
    }

    public ResourcePropertySource(String location) throws IOException {
        this(new DefaultResourceLoader().getResource(location));
    }

    private ResourcePropertySource(String name2, String resourceName, Map<String, Object> source2) {
        super(name2, source2);
        this.resourceName = resourceName;
    }

    public ResourcePropertySource withName(String name2) {
        if (this.name.equals(name2)) {
            return this;
        }
        if (this.resourceName != null) {
            if (this.resourceName.equals(name2)) {
                return new ResourcePropertySource(this.resourceName, null, (Map)this.source);
            }
            return new ResourcePropertySource(name2, this.resourceName, (Map)this.source);
        }
        return new ResourcePropertySource(name2, this.name, (Map)this.source);
    }

    public ResourcePropertySource withResourceName() {
        if (this.resourceName == null) {
            return this;
        }
        return new ResourcePropertySource(this.resourceName, null, (Map)this.source);
    }

    private static String getNameForResource(Resource resource2) {
        String name2 = resource2.getDescription();
        if (!StringUtils.hasText(name2)) {
            name2 = resource2.getClass().getSimpleName() + "@" + System.identityHashCode(resource2);
        }
        return name2;
    }
}

