/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;

public class CachingMetadataReaderFactory
extends SimpleMetadataReaderFactory {
    public static final int DEFAULT_CACHE_LIMIT = 256;
    private volatile int cacheLimit = 256;
    private final Map<Resource, MetadataReader> metadataReaderCache = new LinkedHashMap<Resource, MetadataReader>(256, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Resource, MetadataReader> eldest) {
            return this.size() > CachingMetadataReaderFactory.this.getCacheLimit();
        }
    };

    public CachingMetadataReaderFactory() {
    }

    public CachingMetadataReaderFactory(ResourceLoader resourceLoader) {
        super(resourceLoader);
    }

    public CachingMetadataReaderFactory(ClassLoader classLoader) {
        super(classLoader);
    }

    public void setCacheLimit(int cacheLimit) {
        this.cacheLimit = cacheLimit;
    }

    public int getCacheLimit() {
        return this.cacheLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetadataReader getMetadataReader(Resource resource2) throws IOException {
        if (this.getCacheLimit() <= 0) {
            return super.getMetadataReader(resource2);
        }
        Map<Resource, MetadataReader> map2 = this.metadataReaderCache;
        synchronized (map2) {
            MetadataReader metadataReader = this.metadataReaderCache.get(resource2);
            if (metadataReader == null) {
                metadataReader = super.getMetadataReader(resource2);
                this.metadataReaderCache.put(resource2, metadataReader);
            }
            return metadataReader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Map<Resource, MetadataReader> map2 = this.metadataReaderCache;
        synchronized (map2) {
            this.metadataReaderCache.clear();
        }
    }
}

