/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading;

import java.lang.instrument.ClassFileTransformer;
import org.springframework.core.OverridingClassLoader;
import org.springframework.instrument.classloading.WeavingTransformer;
import org.springframework.lang.UsesJava7;

@UsesJava7
public class SimpleInstrumentableClassLoader
extends OverridingClassLoader {
    private final WeavingTransformer weavingTransformer;

    public SimpleInstrumentableClassLoader(ClassLoader parent) {
        super(parent);
        this.weavingTransformer = new WeavingTransformer(parent);
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this.weavingTransformer.addTransformer(transformer);
    }

    @Override
    protected byte[] transformIfNecessary(String name2, byte[] bytes2) {
        return this.weavingTransformer.transformIfNecessary(name2, bytes2);
    }

    static {
        if (parallelCapableClassLoaderAvailable) {
            ClassLoader.registerAsParallelCapable();
        }
    }
}

