/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading.jboss;

import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;

class JBossMCTranslatorAdapter
implements InvocationHandler {
    private final ClassFileTransformer transformer;

    public JBossMCTranslatorAdapter(ClassFileTransformer transformer) {
        this.transformer = transformer;
    }

    @Override
    public Object invoke(Object proxy2, Method method, Object[] args) throws Throwable {
        String name2 = method.getName();
        if ("equals".equals(name2)) {
            return proxy2 == args[0];
        }
        if ("hashCode".equals(name2)) {
            return this.hashCode();
        }
        if ("toString".equals(name2)) {
            return this.toString();
        }
        if ("transform".equals(name2)) {
            return this.transform((ClassLoader)args[0], (String)args[1], (Class)args[2], (ProtectionDomain)args[3], (byte[])args[4]);
        }
        if ("unregisterClassLoader".equals(name2)) {
            this.unregisterClassLoader((ClassLoader)args[0]);
            return null;
        }
        throw new IllegalArgumentException("Unknown method: " + method);
    }

    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws Exception {
        return this.transformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
    }

    public void unregisterClassLoader(ClassLoader loader) {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getName());
        builder.append(" for transformer: ");
        builder.append(this.transformer);
        return builder.toString();
    }
}

