/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.objenesis.instantiator.basic;

import java.io.ObjectStreamClass;
import java.lang.reflect.Method;
import org.springframework.objenesis.ObjenesisException;
import org.springframework.objenesis.instantiator.ObjectInstantiator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectStreamClassInstantiator<T>
implements ObjectInstantiator<T> {
    private static Method newInstanceMethod;
    private final ObjectStreamClass objStreamClass;

    private static void initialize() {
        if (newInstanceMethod == null) {
            try {
                newInstanceMethod = ObjectStreamClass.class.getDeclaredMethod("newInstance", new Class[0]);
                newInstanceMethod.setAccessible(true);
            }
            catch (RuntimeException e2) {
                throw new ObjenesisException(e2);
            }
            catch (NoSuchMethodException e3) {
                throw new ObjenesisException(e3);
            }
        }
    }

    public ObjectStreamClassInstantiator(Class<T> type2) {
        ObjectStreamClassInstantiator.initialize();
        this.objStreamClass = ObjectStreamClass.lookup(type2);
    }

    @Override
    public T newInstance() {
        try {
            return (T)newInstanceMethod.invoke((Object)this.objStreamClass, new Object[0]);
        }
        catch (Exception e2) {
            throw new ObjenesisException(e2);
        }
    }
}

