/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.objenesis.strategy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.springframework.objenesis.ObjenesisException;
import org.springframework.objenesis.instantiator.ObjectInstantiator;
import org.springframework.objenesis.strategy.InstantiatorStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleInstantiatorStrategy
implements InstantiatorStrategy {
    private Constructor<?> constructor;

    public <T extends ObjectInstantiator<?>> SingleInstantiatorStrategy(Class<T> instantiator) {
        try {
            this.constructor = instantiator.getConstructor(Class.class);
        }
        catch (NoSuchMethodException e2) {
            throw new ObjenesisException(e2);
        }
    }

    @Override
    public <T> ObjectInstantiator<T> newInstantiatorOf(Class<T> type2) {
        try {
            return (ObjectInstantiator)this.constructor.newInstance(type2);
        }
        catch (InstantiationException e2) {
            throw new ObjenesisException(e2);
        }
        catch (IllegalAccessException e3) {
            throw new ObjenesisException(e3);
        }
        catch (InvocationTargetException e4) {
            throw new ObjenesisException(e4);
        }
    }
}

