/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class LinkedCaseInsensitiveMap<V>
extends LinkedHashMap<String, V> {
    private final Map<String, String> caseInsensitiveKeys;
    private final Locale locale;

    public LinkedCaseInsensitiveMap() {
        this((Locale)null);
    }

    public LinkedCaseInsensitiveMap(Locale locale) {
        this.caseInsensitiveKeys = new HashMap<String, String>();
        this.locale = locale != null ? locale : Locale.getDefault();
    }

    public LinkedCaseInsensitiveMap(int initialCapacity) {
        this(initialCapacity, null);
    }

    public LinkedCaseInsensitiveMap(int initialCapacity, Locale locale) {
        super(initialCapacity);
        this.caseInsensitiveKeys = new HashMap<String, String>(initialCapacity);
        this.locale = locale != null ? locale : Locale.getDefault();
    }

    @Override
    public V put(String key2, V value) {
        String oldKey = this.caseInsensitiveKeys.put(this.convertKey(key2), key2);
        if (oldKey != null && !oldKey.equals(key2)) {
            super.remove(oldKey);
        }
        return super.put(key2, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> map2) {
        if (map2.isEmpty()) {
            return;
        }
        for (Map.Entry<String, V> entry : map2.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean containsKey(Object key2) {
        return key2 instanceof String && this.caseInsensitiveKeys.containsKey(this.convertKey((String)key2));
    }

    @Override
    public V get(Object key2) {
        if (key2 instanceof String) {
            return super.get(this.caseInsensitiveKeys.get(this.convertKey((String)key2)));
        }
        return null;
    }

    @Override
    public V remove(Object key2) {
        if (key2 instanceof String) {
            return super.remove(this.caseInsensitiveKeys.remove(this.convertKey((String)key2)));
        }
        return null;
    }

    @Override
    public void clear() {
        this.caseInsensitiveKeys.clear();
        super.clear();
    }

    protected String convertKey(String key2) {
        return key2.toLowerCase(this.locale);
    }
}

