/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.comparator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.util.comparator.InvertibleComparator;

public class CompoundComparator<T>
implements Comparator<T>,
Serializable {
    private final List<InvertibleComparator> comparators;

    public CompoundComparator() {
        this.comparators = new ArrayList<InvertibleComparator>();
    }

    public CompoundComparator(Comparator ... comparators) {
        Assert.notNull(comparators, "Comparators must not be null");
        this.comparators = new ArrayList<InvertibleComparator>(comparators.length);
        for (Comparator comparator2 : comparators) {
            this.addComparator(comparator2);
        }
    }

    public void addComparator(Comparator<? extends T> comparator2) {
        if (comparator2 instanceof InvertibleComparator) {
            this.comparators.add((InvertibleComparator)comparator2);
        } else {
            this.comparators.add(new InvertibleComparator<T>(comparator2));
        }
    }

    public void addComparator(Comparator<? extends T> comparator2, boolean ascending) {
        this.comparators.add(new InvertibleComparator<T>(comparator2, ascending));
    }

    public void setComparator(int index2, Comparator<? extends T> comparator2) {
        if (comparator2 instanceof InvertibleComparator) {
            this.comparators.set(index2, (InvertibleComparator)comparator2);
        } else {
            this.comparators.set(index2, new InvertibleComparator<T>(comparator2));
        }
    }

    public void setComparator(int index2, Comparator<T> comparator2, boolean ascending) {
        this.comparators.set(index2, new InvertibleComparator<T>(comparator2, ascending));
    }

    public void invertOrder() {
        for (InvertibleComparator comparator2 : this.comparators) {
            comparator2.invertOrder();
        }
    }

    public void invertOrder(int index2) {
        this.comparators.get(index2).invertOrder();
    }

    public void setAscendingOrder(int index2) {
        this.comparators.get(index2).setAscending(true);
    }

    public void setDescendingOrder(int index2) {
        this.comparators.get(index2).setAscending(false);
    }

    public int getComparatorCount() {
        return this.comparators.size();
    }

    @Override
    public int compare(T o1, T o2) {
        Assert.state(this.comparators.size() > 0, "No sort definitions have been added to this CompoundComparator to compare");
        for (InvertibleComparator comparator2 : this.comparators) {
            int result = comparator2.compare(o1, o2);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CompoundComparator)) {
            return false;
        }
        CompoundComparator other = (CompoundComparator)obj;
        return this.comparators.equals(other.comparators);
    }

    public int hashCode() {
        return this.comparators.hashCode();
    }

    public String toString() {
        return "CompoundComparator: " + this.comparators;
    }
}

