/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.support;

import java.util.Map;
import org.springframework.ui.ExtendedModelMap;
import org.springframework.validation.BindingResult;

public class BindingAwareModelMap
extends ExtendedModelMap {
    @Override
    public Object put(String key2, Object value) {
        this.removeBindingResultIfNecessary(key2, value);
        return super.put(key2, value);
    }

    @Override
    public void putAll(Map<? extends String, ?> map2) {
        for (Map.Entry<String, ?> entry : map2.entrySet()) {
            this.removeBindingResultIfNecessary(entry.getKey(), entry.getValue());
        }
        super.putAll(map2);
    }

    private void removeBindingResultIfNecessary(Object key2, Object value) {
        String bindingResultKey;
        BindingResult bindingResult;
        String attributeName;
        if (key2 instanceof String && !(attributeName = (String)key2).startsWith(BindingResult.MODEL_KEY_PREFIX) && (bindingResult = (BindingResult)this.get(bindingResultKey = BindingResult.MODEL_KEY_PREFIX + attributeName)) != null && bindingResult.getTarget() != value) {
            this.remove(bindingResultKey);
        }
    }
}

