/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.accept;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.accept.MappingMediaTypeFileExtensionResolver;
import org.springframework.web.accept.MediaTypeFileExtensionResolver;
import org.springframework.web.context.request.NativeWebRequest;

public abstract class AbstractMappingContentNegotiationStrategy
extends MappingMediaTypeFileExtensionResolver
implements ContentNegotiationStrategy,
MediaTypeFileExtensionResolver {
    public AbstractMappingContentNegotiationStrategy(Map<String, MediaType> mediaTypes) {
        super(mediaTypes);
    }

    @Override
    public List<MediaType> resolveMediaTypes(NativeWebRequest webRequest) throws HttpMediaTypeNotAcceptableException {
        String key2 = this.getMediaTypeKey(webRequest);
        if (StringUtils.hasText(key2)) {
            MediaType mediaType = this.lookupMediaType(key2);
            if (mediaType != null) {
                this.handleMatch(key2, mediaType);
                return Collections.singletonList(mediaType);
            }
            mediaType = this.handleNoMatch(webRequest, key2);
            if (mediaType != null) {
                this.addMapping(key2, mediaType);
                return Collections.singletonList(mediaType);
            }
        }
        return Collections.emptyList();
    }

    protected abstract String getMediaTypeKey(NativeWebRequest var1);

    protected void handleMatch(String mappingKey, MediaType mediaType) {
    }

    protected MediaType handleNoMatch(NativeWebRequest request, String key2) throws HttpMediaTypeNotAcceptableException {
        return null;
    }
}

