/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestAttributes;

public abstract class AbstractRequestAttributes
implements RequestAttributes {
    protected final Map<String, Runnable> requestDestructionCallbacks = new LinkedHashMap<String, Runnable>(8);
    private volatile boolean requestActive = true;

    public void requestCompleted() {
        this.executeRequestDestructionCallbacks();
        this.updateAccessedSessionAttributes();
        this.requestActive = false;
    }

    protected final boolean isRequestActive() {
        return this.requestActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void registerRequestDestructionCallback(String name2, Runnable callback) {
        Assert.notNull(name2, "Name must not be null");
        Assert.notNull(callback, "Callback must not be null");
        Map<String, Runnable> map2 = this.requestDestructionCallbacks;
        synchronized (map2) {
            this.requestDestructionCallbacks.put(name2, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeRequestDestructionCallback(String name2) {
        Assert.notNull(name2, "Name must not be null");
        Map<String, Runnable> map2 = this.requestDestructionCallbacks;
        synchronized (map2) {
            this.requestDestructionCallbacks.remove(name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRequestDestructionCallbacks() {
        Map<String, Runnable> map2 = this.requestDestructionCallbacks;
        synchronized (map2) {
            for (Runnable runnable : this.requestDestructionCallbacks.values()) {
                runnable.run();
            }
            this.requestDestructionCallbacks.clear();
        }
    }

    protected abstract void updateAccessedSessionAttributes();
}

