/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.AbstractRequestAttributes;
import org.springframework.web.context.request.DestructionCallbackBindingListener;
import org.springframework.web.util.WebUtils;

public class ServletRequestAttributes
extends AbstractRequestAttributes {
    public static final String DESTRUCTION_CALLBACK_NAME_PREFIX = ServletRequestAttributes.class.getName() + ".DESTRUCTION_CALLBACK.";
    protected static final Set<Class<?>> immutableValueTypes = new HashSet(16);
    private final HttpServletRequest request;
    private HttpServletResponse response;
    private volatile HttpSession session;
    private final Map<String, Object> sessionAttributesToUpdate = new ConcurrentHashMap<String, Object>(1);

    public ServletRequestAttributes(HttpServletRequest request) {
        Assert.notNull(request, "Request must not be null");
        this.request = request;
    }

    public ServletRequestAttributes(HttpServletRequest request, HttpServletResponse response) {
        this(request);
        this.response = response;
    }

    public final HttpServletRequest getRequest() {
        return this.request;
    }

    public final HttpServletResponse getResponse() {
        return this.response;
    }

    protected final HttpSession getSession(boolean allowCreate) {
        if (this.isRequestActive()) {
            return this.request.getSession(allowCreate);
        }
        if (this.session == null && allowCreate) {
            throw new IllegalStateException("No session found and request already completed - cannot create new session!");
        }
        return this.session;
    }

    @Override
    public Object getAttribute(String name2, int scope) {
        if (scope == 0) {
            if (!this.isRequestActive()) {
                throw new IllegalStateException("Cannot ask for request attribute - request is not active anymore!");
            }
            return this.request.getAttribute(name2);
        }
        HttpSession session = this.getSession(false);
        if (session != null) {
            try {
                Object value = session.getAttribute(name2);
                if (value != null) {
                    this.sessionAttributesToUpdate.put(name2, value);
                }
                return value;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void setAttribute(String name2, Object value, int scope) {
        if (scope == 0) {
            if (!this.isRequestActive()) {
                throw new IllegalStateException("Cannot set request attribute - request is not active anymore!");
            }
            this.request.setAttribute(name2, value);
        } else {
            HttpSession session = this.getSession(true);
            this.sessionAttributesToUpdate.remove(name2);
            session.setAttribute(name2, value);
        }
    }

    @Override
    public void removeAttribute(String name2, int scope) {
        if (scope == 0) {
            if (this.isRequestActive()) {
                this.request.removeAttribute(name2);
                this.removeRequestDestructionCallback(name2);
            }
        } else {
            HttpSession session = this.getSession(false);
            if (session != null) {
                this.sessionAttributesToUpdate.remove(name2);
                try {
                    session.removeAttribute(name2);
                    session.removeAttribute(DESTRUCTION_CALLBACK_NAME_PREFIX + name2);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public String[] getAttributeNames(int scope) {
        if (scope == 0) {
            if (!this.isRequestActive()) {
                throw new IllegalStateException("Cannot ask for request attributes - request is not active anymore!");
            }
            return StringUtils.toStringArray(this.request.getAttributeNames());
        }
        HttpSession session = this.getSession(false);
        if (session != null) {
            try {
                return StringUtils.toStringArray(session.getAttributeNames());
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return new String[0];
    }

    @Override
    public void registerDestructionCallback(String name2, Runnable callback, int scope) {
        if (scope == 0) {
            this.registerRequestDestructionCallback(name2, callback);
        } else {
            this.registerSessionDestructionCallback(name2, callback);
        }
    }

    @Override
    public Object resolveReference(String key2) {
        if ("request".equals(key2)) {
            return this.request;
        }
        if ("session".equals(key2)) {
            return this.getSession(true);
        }
        return null;
    }

    @Override
    public String getSessionId() {
        return this.getSession(true).getId();
    }

    @Override
    public Object getSessionMutex() {
        return WebUtils.getSessionMutex(this.getSession(true));
    }

    @Override
    protected void updateAccessedSessionAttributes() {
        this.session = this.request.getSession(false);
        if (this.session != null) {
            try {
                for (Map.Entry<String, Object> entry : this.sessionAttributesToUpdate.entrySet()) {
                    String name2 = entry.getKey();
                    Object newValue = entry.getValue();
                    Object oldValue = this.session.getAttribute(name2);
                    if (oldValue != newValue || this.isImmutableSessionAttribute(name2, newValue)) continue;
                    this.session.setAttribute(name2, newValue);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.sessionAttributesToUpdate.clear();
    }

    protected boolean isImmutableSessionAttribute(String name2, Object value) {
        return value == null || immutableValueTypes.contains(value.getClass());
    }

    protected void registerSessionDestructionCallback(String name2, Runnable callback) {
        HttpSession session = this.getSession(true);
        session.setAttribute(DESTRUCTION_CALLBACK_NAME_PREFIX + name2, new DestructionCallbackBindingListener(callback));
    }

    public String toString() {
        return this.request.toString();
    }

    static {
        immutableValueTypes.addAll(NumberUtils.STANDARD_NUMBER_TYPES);
        immutableValueTypes.add(Boolean.class);
        immutableValueTypes.add(Character.class);
        immutableValueTypes.add(String.class);
    }
}

