/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.util.Assert;

public class ServletContextScope
implements Scope,
DisposableBean {
    private final ServletContext servletContext;
    private final Map<String, Runnable> destructionCallbacks = new LinkedHashMap<String, Runnable>();

    public ServletContextScope(ServletContext servletContext) {
        Assert.notNull(servletContext, "ServletContext must not be null");
        this.servletContext = servletContext;
    }

    @Override
    public Object get(String name2, ObjectFactory<?> objectFactory) {
        Object scopedObject = this.servletContext.getAttribute(name2);
        if (scopedObject == null) {
            scopedObject = objectFactory.getObject();
            this.servletContext.setAttribute(name2, scopedObject);
        }
        return scopedObject;
    }

    @Override
    public Object remove(String name2) {
        Object scopedObject = this.servletContext.getAttribute(name2);
        if (scopedObject != null) {
            this.servletContext.removeAttribute(name2);
            this.destructionCallbacks.remove(name2);
            return scopedObject;
        }
        return null;
    }

    @Override
    public void registerDestructionCallback(String name2, Runnable callback) {
        this.destructionCallbacks.put(name2, callback);
    }

    @Override
    public Object resolveContextualObject(String key2) {
        return null;
    }

    @Override
    public String getConversationId() {
        return null;
    }

    @Override
    public void destroy() {
        for (Runnable runnable : this.destructionCallbacks.values()) {
            runnable.run();
        }
        this.destructionCallbacks.clear();
    }
}

