/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.regex.Pattern;
import org.springframework.util.Assert;
import org.springframework.web.util.HierarchicalUriComponents;

public abstract class UriUtils {
    private static final String SCHEME_PATTERN = "([^:/?#]+):";
    private static final String HTTP_PATTERN = "(http|https):";
    private static final String USERINFO_PATTERN = "([^@/]*)";
    private static final String HOST_PATTERN = "([^/?#:]*)";
    private static final String PORT_PATTERN = "(\\d*)";
    private static final String PATH_PATTERN = "([^?#]*)";
    private static final String QUERY_PATTERN = "([^#]*)";
    private static final String LAST_PATTERN = "(.*)";
    private static final Pattern URI_PATTERN = Pattern.compile("^(([^:/?#]+):)?(//(([^@/]*)@)?([^/?#:]*)(:(\\d*))?)?([^?#]*)(\\?([^#]*))?(#(.*))?");
    private static final Pattern HTTP_URL_PATTERN = Pattern.compile("^(http|https):(//(([^@/]*)@)?([^/?#:]*)(:(\\d*))?)?([^?#]*)(\\?(.*))?");

    public static String encodeScheme(String scheme, String encoding2) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(scheme, encoding2, HierarchicalUriComponents.Type.SCHEME);
    }

    public static String encodeAuthority(String authority, String encoding2) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(authority, encoding2, HierarchicalUriComponents.Type.AUTHORITY);
    }

    public static String encodeUserInfo(String userInfo, String encoding2) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(userInfo, encoding2, HierarchicalUriComponents.Type.USER_INFO);
    }

    public static String encodeHost(String host, String encoding2) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(host, encoding2, HierarchicalUriComponents.Type.HOST_IPV4);
    }

    public static String encodePort(String port, String encoding2) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(port, encoding2, HierarchicalUriComponents.Type.PORT);
    }

    public static String encodePath(String path2, String encoding2) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(path2, encoding2, HierarchicalUriComponents.Type.PATH);
    }

    public static String encodePathSegment(String segment, String encoding2) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(segment, encoding2, HierarchicalUriComponents.Type.PATH_SEGMENT);
    }

    public static String encodeQuery(String query, String encoding2) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(query, encoding2, HierarchicalUriComponents.Type.QUERY);
    }

    public static String encodeQueryParam(String queryParam, String encoding2) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(queryParam, encoding2, HierarchicalUriComponents.Type.QUERY_PARAM);
    }

    public static String encodeFragment(String fragment, String encoding2) throws UnsupportedEncodingException {
        return HierarchicalUriComponents.encodeUriComponent(fragment, encoding2, HierarchicalUriComponents.Type.FRAGMENT);
    }

    public static String encode(String source2, String encoding2) throws UnsupportedEncodingException {
        HierarchicalUriComponents.Type type2 = HierarchicalUriComponents.Type.URI;
        return HierarchicalUriComponents.encodeUriComponent(source2, encoding2, type2);
    }

    public static String decode(String source2, String encoding2) throws UnsupportedEncodingException {
        Assert.notNull(source2, "Source must not be null");
        Assert.hasLength(encoding2, "Encoding must not be empty");
        int length = source2.length();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        boolean changed = false;
        for (int i = 0; i < length; ++i) {
            char ch = source2.charAt(i);
            if (ch == '%') {
                if (i + 2 < length) {
                    char hex1 = source2.charAt(i + 1);
                    char hex2 = source2.charAt(i + 2);
                    int u = Character.digit(hex1, 16);
                    int l = Character.digit(hex2, 16);
                    if (u == -1 || l == -1) {
                        throw new IllegalArgumentException("Invalid encoded sequence \"" + source2.substring(i) + "\"");
                    }
                    bos.write((char)((u << 4) + l));
                    i += 2;
                    changed = true;
                    continue;
                }
                throw new IllegalArgumentException("Invalid encoded sequence \"" + source2.substring(i) + "\"");
            }
            bos.write(ch);
        }
        return changed ? new String(bos.toByteArray(), encoding2) : source2;
    }
}

