/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.http.HttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class WebUtils {
    public static final String INCLUDE_REQUEST_URI_ATTRIBUTE = "javax.servlet.include.request_uri";
    public static final String INCLUDE_CONTEXT_PATH_ATTRIBUTE = "javax.servlet.include.context_path";
    public static final String INCLUDE_SERVLET_PATH_ATTRIBUTE = "javax.servlet.include.servlet_path";
    public static final String INCLUDE_PATH_INFO_ATTRIBUTE = "javax.servlet.include.path_info";
    public static final String INCLUDE_QUERY_STRING_ATTRIBUTE = "javax.servlet.include.query_string";
    public static final String FORWARD_REQUEST_URI_ATTRIBUTE = "javax.servlet.forward.request_uri";
    public static final String FORWARD_CONTEXT_PATH_ATTRIBUTE = "javax.servlet.forward.context_path";
    public static final String FORWARD_SERVLET_PATH_ATTRIBUTE = "javax.servlet.forward.servlet_path";
    public static final String FORWARD_PATH_INFO_ATTRIBUTE = "javax.servlet.forward.path_info";
    public static final String FORWARD_QUERY_STRING_ATTRIBUTE = "javax.servlet.forward.query_string";
    public static final String ERROR_STATUS_CODE_ATTRIBUTE = "javax.servlet.error.status_code";
    public static final String ERROR_EXCEPTION_TYPE_ATTRIBUTE = "javax.servlet.error.exception_type";
    public static final String ERROR_MESSAGE_ATTRIBUTE = "javax.servlet.error.message";
    public static final String ERROR_EXCEPTION_ATTRIBUTE = "javax.servlet.error.exception";
    public static final String ERROR_REQUEST_URI_ATTRIBUTE = "javax.servlet.error.request_uri";
    public static final String ERROR_SERVLET_NAME_ATTRIBUTE = "javax.servlet.error.servlet_name";
    public static final String CONTENT_TYPE_CHARSET_PREFIX = ";charset=";
    public static final String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";
    public static final String TEMP_DIR_CONTEXT_ATTRIBUTE = "javax.servlet.context.tempdir";
    public static final String HTML_ESCAPE_CONTEXT_PARAM = "defaultHtmlEscape";
    public static final String RESPONSE_ENCODED_HTML_ESCAPE_CONTEXT_PARAM = "responseEncodedHtmlEscape";
    public static final String WEB_APP_ROOT_KEY_PARAM = "webAppRootKey";
    public static final String DEFAULT_WEB_APP_ROOT_KEY = "webapp.root";
    public static final String[] SUBMIT_IMAGE_SUFFIXES = new String[]{".x", ".y"};
    public static final String SESSION_MUTEX_ATTRIBUTE = WebUtils.class.getName() + ".MUTEX";

    public static void setWebAppRootSystemProperty(ServletContext servletContext) throws IllegalStateException {
        Assert.notNull(servletContext, "ServletContext must not be null");
        String root2 = servletContext.getRealPath("/");
        if (root2 == null) {
            throw new IllegalStateException("Cannot set web app root system property when WAR file is not expanded");
        }
        String param = servletContext.getInitParameter(WEB_APP_ROOT_KEY_PARAM);
        String key2 = param != null ? param : DEFAULT_WEB_APP_ROOT_KEY;
        String oldValue = System.getProperty(key2);
        if (oldValue != null && !StringUtils.pathEquals(oldValue, root2)) {
            throw new IllegalStateException("Web app root system property already set to different value: '" + key2 + "' = [" + oldValue + "] instead of [" + root2 + "] - " + "Choose unique values for the 'webAppRootKey' context-param in your web.xml files!");
        }
        System.setProperty(key2, root2);
        servletContext.log("Set web app root system property: '" + key2 + "' = [" + root2 + "]");
    }

    public static void removeWebAppRootSystemProperty(ServletContext servletContext) {
        Assert.notNull(servletContext, "ServletContext must not be null");
        String param = servletContext.getInitParameter(WEB_APP_ROOT_KEY_PARAM);
        String key2 = param != null ? param : DEFAULT_WEB_APP_ROOT_KEY;
        System.getProperties().remove(key2);
    }

    @Deprecated
    public static boolean isDefaultHtmlEscape(ServletContext servletContext) {
        if (servletContext == null) {
            return false;
        }
        String param = servletContext.getInitParameter(HTML_ESCAPE_CONTEXT_PARAM);
        return Boolean.valueOf(param);
    }

    public static Boolean getDefaultHtmlEscape(ServletContext servletContext) {
        if (servletContext == null) {
            return null;
        }
        String param = servletContext.getInitParameter(HTML_ESCAPE_CONTEXT_PARAM);
        return StringUtils.hasText(param) ? Boolean.valueOf(param) : null;
    }

    public static Boolean getResponseEncodedHtmlEscape(ServletContext servletContext) {
        if (servletContext == null) {
            return null;
        }
        String param = servletContext.getInitParameter(RESPONSE_ENCODED_HTML_ESCAPE_CONTEXT_PARAM);
        return StringUtils.hasText(param) ? Boolean.valueOf(param) : null;
    }

    public static File getTempDir(ServletContext servletContext) {
        Assert.notNull(servletContext, "ServletContext must not be null");
        return (File)servletContext.getAttribute(TEMP_DIR_CONTEXT_ATTRIBUTE);
    }

    public static String getRealPath(ServletContext servletContext, String path2) throws FileNotFoundException {
        String realPath;
        Assert.notNull(servletContext, "ServletContext must not be null");
        if (!path2.startsWith("/")) {
            path2 = "/" + path2;
        }
        if ((realPath = servletContext.getRealPath(path2)) == null) {
            throw new FileNotFoundException("ServletContext resource [" + path2 + "] cannot be resolved to absolute file path - " + "web application archive not expanded?");
        }
        return realPath;
    }

    public static String getSessionId(HttpServletRequest request) {
        Assert.notNull(request, "Request must not be null");
        HttpSession session = request.getSession(false);
        return session != null ? session.getId() : null;
    }

    public static Object getSessionAttribute(HttpServletRequest request, String name2) {
        Assert.notNull(request, "Request must not be null");
        HttpSession session = request.getSession(false);
        return session != null ? session.getAttribute(name2) : null;
    }

    public static Object getRequiredSessionAttribute(HttpServletRequest request, String name2) throws IllegalStateException {
        Object attr = WebUtils.getSessionAttribute(request, name2);
        if (attr == null) {
            throw new IllegalStateException("No session attribute '" + name2 + "' found");
        }
        return attr;
    }

    public static void setSessionAttribute(HttpServletRequest request, String name2, Object value) {
        Assert.notNull(request, "Request must not be null");
        if (value != null) {
            request.getSession().setAttribute(name2, value);
        } else {
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.removeAttribute(name2);
            }
        }
    }

    public static Object getOrCreateSessionAttribute(HttpSession session, String name2, Class<?> clazz) throws IllegalArgumentException {
        Assert.notNull(session, "Session must not be null");
        Object sessionObject = session.getAttribute(name2);
        if (sessionObject == null) {
            try {
                sessionObject = clazz.newInstance();
            }
            catch (InstantiationException ex) {
                throw new IllegalArgumentException("Could not instantiate class [" + clazz.getName() + "] for session attribute '" + name2 + "': " + ex.getMessage());
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException("Could not access default constructor of class [" + clazz.getName() + "] for session attribute '" + name2 + "': " + ex.getMessage());
            }
            session.setAttribute(name2, sessionObject);
        }
        return sessionObject;
    }

    public static Object getSessionMutex(HttpSession session) {
        Assert.notNull(session, "Session must not be null");
        Object mutex = session.getAttribute(SESSION_MUTEX_ATTRIBUTE);
        if (mutex == null) {
            mutex = session;
        }
        return mutex;
    }

    public static <T> T getNativeRequest(ServletRequest request, Class<T> requiredType) {
        if (requiredType != null) {
            if (requiredType.isInstance(request)) {
                return (T)request;
            }
            if (request instanceof ServletRequestWrapper) {
                return WebUtils.getNativeRequest(((ServletRequestWrapper)request).getRequest(), requiredType);
            }
        }
        return null;
    }

    public static <T> T getNativeResponse(ServletResponse response, Class<T> requiredType) {
        if (requiredType != null) {
            if (requiredType.isInstance(response)) {
                return (T)response;
            }
            if (response instanceof ServletResponseWrapper) {
                return WebUtils.getNativeResponse(((ServletResponseWrapper)response).getResponse(), requiredType);
            }
        }
        return null;
    }

    public static boolean isIncludeRequest(ServletRequest request) {
        return request.getAttribute(INCLUDE_REQUEST_URI_ATTRIBUTE) != null;
    }

    public static void exposeErrorRequestAttributes(HttpServletRequest request, Throwable ex, String servletName) {
        WebUtils.exposeRequestAttributeIfNotPresent(request, ERROR_STATUS_CODE_ATTRIBUTE, 200);
        WebUtils.exposeRequestAttributeIfNotPresent(request, ERROR_EXCEPTION_TYPE_ATTRIBUTE, ex.getClass());
        WebUtils.exposeRequestAttributeIfNotPresent(request, ERROR_MESSAGE_ATTRIBUTE, ex.getMessage());
        WebUtils.exposeRequestAttributeIfNotPresent(request, ERROR_EXCEPTION_ATTRIBUTE, ex);
        WebUtils.exposeRequestAttributeIfNotPresent(request, ERROR_REQUEST_URI_ATTRIBUTE, request.getRequestURI());
        WebUtils.exposeRequestAttributeIfNotPresent(request, ERROR_SERVLET_NAME_ATTRIBUTE, servletName);
    }

    private static void exposeRequestAttributeIfNotPresent(ServletRequest request, String name2, Object value) {
        if (request.getAttribute(name2) == null) {
            request.setAttribute(name2, value);
        }
    }

    public static void clearErrorRequestAttributes(HttpServletRequest request) {
        request.removeAttribute(ERROR_STATUS_CODE_ATTRIBUTE);
        request.removeAttribute(ERROR_EXCEPTION_TYPE_ATTRIBUTE);
        request.removeAttribute(ERROR_MESSAGE_ATTRIBUTE);
        request.removeAttribute(ERROR_EXCEPTION_ATTRIBUTE);
        request.removeAttribute(ERROR_REQUEST_URI_ATTRIBUTE);
        request.removeAttribute(ERROR_SERVLET_NAME_ATTRIBUTE);
    }

    public static void exposeRequestAttributes(ServletRequest request, Map<String, ?> attributes) {
        Assert.notNull(request, "Request must not be null");
        Assert.notNull(attributes, "Attributes Map must not be null");
        for (Map.Entry<String, ?> entry : attributes.entrySet()) {
            request.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public static Cookie getCookie(HttpServletRequest request, String name2) {
        Assert.notNull(request, "Request must not be null");
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!name2.equals(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    public static boolean hasSubmitParameter(ServletRequest request, String name2) {
        Assert.notNull(request, "Request must not be null");
        if (request.getParameter(name2) != null) {
            return true;
        }
        for (String suffix : SUBMIT_IMAGE_SUFFIXES) {
            if (request.getParameter(name2 + suffix) == null) continue;
            return true;
        }
        return false;
    }

    public static String findParameterValue(ServletRequest request, String name2) {
        return WebUtils.findParameterValue(request.getParameterMap(), name2);
    }

    public static String findParameterValue(Map<String, ?> parameters, String name2) {
        Object value = parameters.get(name2);
        if (value instanceof String[]) {
            String[] values = (String[])value;
            return values.length > 0 ? values[0] : null;
        }
        if (value != null) {
            return value.toString();
        }
        String prefix = name2 + "_";
        for (String paramName : parameters.keySet()) {
            if (!paramName.startsWith(prefix)) continue;
            for (String suffix : SUBMIT_IMAGE_SUFFIXES) {
                if (!paramName.endsWith(suffix)) continue;
                return paramName.substring(prefix.length(), paramName.length() - suffix.length());
            }
            return paramName.substring(prefix.length());
        }
        return null;
    }

    public static Map<String, Object> getParametersStartingWith(ServletRequest request, String prefix) {
        Assert.notNull(request, "Request must not be null");
        Enumeration<String> paramNames = request.getParameterNames();
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        if (prefix == null) {
            prefix = "";
        }
        while (paramNames != null && paramNames.hasMoreElements()) {
            String paramName = paramNames.nextElement();
            if (!"".equals(prefix) && !paramName.startsWith(prefix)) continue;
            String unprefixed = paramName.substring(prefix.length());
            String[] values = request.getParameterValues(paramName);
            if (values == null || values.length == 0) continue;
            if (values.length > 1) {
                params.put(unprefixed, values);
                continue;
            }
            params.put(unprefixed, values[0]);
        }
        return params;
    }

    public static int getTargetPage(ServletRequest request, String paramPrefix, int currentPage) {
        Enumeration<String> paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = paramNames.nextElement();
            if (!paramName.startsWith(paramPrefix)) continue;
            for (int i = 0; i < SUBMIT_IMAGE_SUFFIXES.length; ++i) {
                String suffix = SUBMIT_IMAGE_SUFFIXES[i];
                if (!paramName.endsWith(suffix)) continue;
                paramName = paramName.substring(0, paramName.length() - suffix.length());
            }
            return Integer.parseInt(paramName.substring(paramPrefix.length()));
        }
        return currentPage;
    }

    public static String extractFilenameFromUrlPath(String urlPath) {
        String filename = WebUtils.extractFullFilenameFromUrlPath(urlPath);
        int dotIndex = filename.lastIndexOf(46);
        if (dotIndex != -1) {
            filename = filename.substring(0, dotIndex);
        }
        return filename;
    }

    public static String extractFullFilenameFromUrlPath(String urlPath) {
        int end = urlPath.indexOf(59);
        if (end == -1 && (end = urlPath.indexOf(63)) == -1) {
            end = urlPath.length();
        }
        int begin = urlPath.lastIndexOf(47, end) + 1;
        return urlPath.substring(begin, end);
    }

    public static MultiValueMap<String, String> parseMatrixVariables(String matrixVariables) {
        LinkedMultiValueMap<String, String> result = new LinkedMultiValueMap<String, String>();
        if (!StringUtils.hasText(matrixVariables)) {
            return result;
        }
        StringTokenizer pairs = new StringTokenizer(matrixVariables, ";");
        while (pairs.hasMoreTokens()) {
            String pair = pairs.nextToken();
            int index2 = pair.indexOf(61);
            if (index2 != -1) {
                String name2 = pair.substring(0, index2);
                String rawValue = pair.substring(index2 + 1);
                for (String value : StringUtils.commaDelimitedListToStringArray(rawValue)) {
                    result.add(name2, value);
                }
                continue;
            }
            result.add(pair, "");
        }
        return result;
    }

    public static boolean isValidOrigin(HttpRequest request, Collection<String> allowedOrigins) {
        Assert.notNull(request, "Request must not be null");
        Assert.notNull(allowedOrigins, "Allowed origins must not be null");
        String origin = request.getHeaders().getOrigin();
        if (origin == null || allowedOrigins.contains("*")) {
            return true;
        }
        if (CollectionUtils.isEmpty(allowedOrigins)) {
            return WebUtils.isSameOrigin(request);
        }
        return allowedOrigins.contains(origin);
    }

    public static boolean isSameOrigin(HttpRequest request) {
        String origin = request.getHeaders().getOrigin();
        if (origin == null) {
            return true;
        }
        UriComponents actualUrl = UriComponentsBuilder.fromHttpRequest(request).build();
        UriComponents originUrl = UriComponentsBuilder.fromOriginHeader(origin).build();
        return actualUrl.getHost().equals(originUrl.getHost()) && WebUtils.getPort(actualUrl) == WebUtils.getPort(originUrl);
    }

    private static int getPort(UriComponents component) {
        int port = component.getPort();
        if (port == -1) {
            if ("http".equals(component.getScheme()) || "ws".equals(component.getScheme())) {
                port = 80;
            } else if ("https".equals(component.getScheme()) || "wss".equals(component.getScheme())) {
                port = 443;
            }
        }
        return port;
    }
}

