/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.client.config;

import java.util.Iterator;
import java.util.NoSuchElementException;

final class Delimiterator
implements Iterator<String> {
    private final String subject;
    private final char delimiter;
    private int i;
    private static final int[] NO_INTS = new int[0];
    private static final long[] NO_LONGS = new long[0];
    private static final String[] NO_STRINGS = new String[0];

    Delimiterator(String subject, char delimiter) {
        this.subject = subject;
        this.delimiter = delimiter;
        this.i = 0;
    }

    static Delimiterator over(String subject, char delimiter) {
        return new Delimiterator(subject, delimiter);
    }

    @Override
    public boolean hasNext() {
        return this.i != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String next() {
        String string2;
        int i = this.i;
        if (i == -1) {
            throw new NoSuchElementException();
        }
        int n = this.subject.indexOf(this.delimiter, i);
        try {
            string2 = n == -1 ? this.subject.substring(i) : this.subject.substring(i, n);
            this.i = n == -1 ? -1 : n + 1;
        }
        catch (Throwable throwable) {
            this.i = n == -1 ? -1 : n + 1;
            throw throwable;
        }
        return string2;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String[] toStringArray() {
        return this.toStringArray(0);
    }

    String[] toStringArray(int count2) {
        if (this.hasNext()) {
            String next2 = this.next();
            String[] strings = this.toStringArray(count2 + 1);
            strings[count2] = next2;
            return strings;
        }
        return count2 == 0 ? NO_STRINGS : new String[count2];
    }

    public int[] toIntArray() throws NumberFormatException {
        return this.toIntArray(0);
    }

    int[] toIntArray(int count2) {
        if (this.hasNext()) {
            String next2 = this.next();
            int[] ints2 = this.toIntArray(count2 + 1);
            ints2[count2] = Integer.parseInt(next2);
            return ints2;
        }
        return count2 == 0 ? NO_INTS : new int[count2];
    }

    public long[] toLongArray() throws NumberFormatException {
        return this.toLongArray(0);
    }

    long[] toLongArray(int count2) {
        if (this.hasNext()) {
            String next2 = this.next();
            long[] longs2 = this.toLongArray(count2 + 1);
            longs2[count2] = Long.parseLong(next2);
            return longs2;
        }
        return count2 == 0 ? NO_LONGS : new long[count2];
    }
}

