/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.client.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.NoSuchElementException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.client.config.ConfigurationXMLStreamReader;
import org.wildfly.client.config.CountingReader;
import org.wildfly.client.config.XMLLocation;
import org.wildfly.client.config._private.ConfigMessages;

class TextXMLStreamReader
implements ConfigurationXMLStreamReader {
    private final String charsetName;
    private final CountingReader reader;
    private final ConfigurationXMLStreamReader parent;
    private final URI uri;
    private final XMLLocation includedFrom;
    private char[] current = new char[512];
    private int len;
    private char[] next = new char[512];
    private int nextLen;

    TextXMLStreamReader(String charsetName, InputStream inputStream, ConfigurationXMLStreamReader parent, URI uri) throws UnsupportedEncodingException {
        this(charsetName, new InputStreamReader(inputStream, charsetName), parent, uri);
    }

    TextXMLStreamReader(Charset charset, InputStream inputStream, ConfigurationXMLStreamReader parent, URI uri) {
        this(charset.name(), new InputStreamReader(inputStream, charset), parent, uri);
    }

    TextXMLStreamReader(String charsetName, Reader reader2, ConfigurationXMLStreamReader parent, URI uri) {
        this(charsetName, reader2 instanceof CountingReader ? (CountingReader)reader2 : new CountingReader(reader2), parent, uri);
    }

    TextXMLStreamReader(String charsetName, CountingReader reader2, ConfigurationXMLStreamReader parent, URI uri) {
        this.charsetName = charsetName;
        this.reader = reader2;
        this.parent = parent;
        this.uri = uri;
        this.includedFrom = this.parent.getLocation();
    }

    @Override
    public XMLLocation getIncludedFrom() {
        return this.includedFrom;
    }

    @Override
    public int next() throws ConfigXMLParseException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        char[] old = this.current;
        this.current = this.next;
        this.len = this.nextLen;
        this.next = old;
        this.nextLen = 0;
        return 4;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public XMLInputFactory getXmlInputFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() throws ConfigXMLParseException {
        if (this.nextLen == 0) {
            int res;
            try {
                res = this.reader.read(this.next);
            }
            catch (IOException e2) {
                throw ConfigMessages.msg.failedToReadInput(this.getLocation(), e2);
            }
            if (res == -1) {
                return false;
            }
            this.nextLen = res;
        }
        return true;
    }

    @Override
    public void close() throws ConfigXMLParseException {
        try {
            this.reader.close();
        }
        catch (IOException e2) {
            throw ConfigMessages.msg.failedToCloseInput(this.getLocation(), e2);
        }
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return null;
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        throw new IllegalStateException();
    }

    @Override
    public int getAttributeCount() {
        throw new IllegalStateException();
    }

    @Override
    public QName getAttributeName(int index2) {
        throw new IllegalStateException();
    }

    @Override
    public String getAttributeNamespace(int index2) {
        throw new IllegalStateException();
    }

    @Override
    public String getAttributeLocalName(int index2) {
        throw new IllegalStateException();
    }

    @Override
    public String getAttributePrefix(int index2) {
        throw new IllegalStateException();
    }

    @Override
    public String getAttributeType(int index2) {
        throw new IllegalStateException();
    }

    @Override
    public String getAttributeValue(int index2) {
        throw new IllegalStateException();
    }

    @Override
    public boolean isAttributeSpecified(int index2) {
        throw new IllegalStateException();
    }

    @Override
    public int getNamespaceCount() {
        throw new IllegalStateException();
    }

    @Override
    public String getNamespacePrefix(int index2) {
        throw new IllegalStateException();
    }

    @Override
    public String getNamespaceURI(int index2) {
        throw new IllegalStateException();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        throw new IllegalStateException();
    }

    @Override
    public int getEventType() {
        return this.len == 0 ? 7 : 4;
    }

    @Override
    public String getText() {
        if (this.len == 0) {
            throw new IllegalStateException();
        }
        return new String(this.current, 0, this.len);
    }

    @Override
    public char[] getTextCharacters() {
        return Arrays.copyOf(this.current, this.len);
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) {
        if (sourceStart > this.len || targetStart > length) {
            return 0;
        }
        int realLen = Math.min(this.len - sourceStart, length);
        System.arraycopy(this.current, sourceStart, target, targetStart, realLen);
        return realLen;
    }

    @Override
    public int getTextStart() {
        return 0;
    }

    @Override
    public int getTextLength() {
        if (this.len == 0) {
            throw new IllegalStateException();
        }
        return this.len;
    }

    @Override
    public String getEncoding() {
        return this.charsetName;
    }

    @Override
    public XMLLocation getLocation() {
        return new XMLLocation(this.includedFrom, this.uri, this.reader.getLineNumber(), this.reader.getColumnNumber(), this.reader.getCharacterOffset());
    }

    @Override
    public QName getName() {
        throw new IllegalStateException();
    }

    @Override
    public String getLocalName() {
        throw new IllegalStateException();
    }

    @Override
    public String getNamespaceURI() {
        throw new IllegalStateException();
    }

    @Override
    public String getPrefix() {
        throw new IllegalStateException();
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public String getCharacterEncodingScheme() {
        return null;
    }

    @Override
    public String getPITarget() {
        return null;
    }

    @Override
    public String getPIData() {
        return null;
    }
}

