/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.archive;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.wildfly.common.archive.Archive;

final class JDKSpecific {
    private JDKSpecific() {
    }

    static ByteBuffer inflate(Inflater inflater, ByteBuffer[] bufs, long offset, int compSize, int uncompSize) throws DataFormatException, IOException {
        int cnt = 0;
        byte[] out = new byte[uncompSize];
        int op = 0;
        while (cnt < compSize) {
            int rem2 = compSize - cnt;
            ByteBuffer buf = bufs[Archive.bufIdx(offset + (long)cnt)].duplicate();
            buf.position(Archive.bufOffs(offset + (long)cnt));
            buf.limit(Math.min(buf.capacity(), buf.position() + rem2));
            cnt += buf.remaining();
            inflater.setInput(buf);
            do {
                op += inflater.inflate(out, op, uncompSize - op);
            } while (!inflater.needsInput());
        }
        if (!inflater.finished()) {
            throw new IOException("Corrupted compression stream");
        }
        return ByteBuffer.wrap(out);
    }
}

