/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.codec;

import org.wildfly.common.codec.Alphabet;

public abstract class Base32Alphabet
extends Alphabet {
    public static final Base32Alphabet STANDARD = new Base32Alphabet(false){

        @Override
        public int encode(int val2) {
            if (val2 <= 25) {
                return 65 + val2;
            }
            assert (val2 < 32);
            return 50 + val2 - 26;
        }

        @Override
        public int decode(int codePoint) {
            if (65 <= codePoint && codePoint <= 90) {
                return codePoint - 65;
            }
            if (50 <= codePoint && codePoint <= 55) {
                return codePoint - 50 + 26;
            }
            return -1;
        }
    };
    public static final Base32Alphabet LOWERCASE = new Base32Alphabet(false){

        @Override
        public int encode(int val2) {
            if (val2 <= 25) {
                return 97 + val2;
            }
            assert (val2 < 32);
            return 50 + val2 - 26;
        }

        @Override
        public int decode(int codePoint) {
            if (97 <= codePoint && codePoint <= 122) {
                return codePoint - 97;
            }
            if (50 <= codePoint && codePoint <= 55) {
                return codePoint - 50 + 26;
            }
            return -1;
        }
    };

    protected Base32Alphabet(boolean littleEndian) {
        super(littleEndian);
    }

    @Override
    public abstract int encode(int var1);

    @Override
    public abstract int decode(int var1);
}

