/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.iteration;

import java.util.NoSuchElementException;
import java.util.function.IntPredicate;
import org.wildfly.common.codec.Base32Alphabet;
import org.wildfly.common.codec.Base64Alphabet;
import org.wildfly.common.iteration.Base16DecodingByteIterator;
import org.wildfly.common.iteration.BiDirIntIterator;
import org.wildfly.common.iteration.BigEndianBase32DecodingByteIterator;
import org.wildfly.common.iteration.BigEndianBase64DecodingByteIterator;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.common.iteration.CharArrayIterator;
import org.wildfly.common.iteration.DelimitedCodePointIterator;
import org.wildfly.common.iteration.IndexIterator;
import org.wildfly.common.iteration.Latin1EncodingByteIterator;
import org.wildfly.common.iteration.LimitedCodePointIterator;
import org.wildfly.common.iteration.LittleEndianBase32DecodingByteIterator;
import org.wildfly.common.iteration.LittleEndianBase64DecodingByteIterator;
import org.wildfly.common.iteration.SkippingCodePointIterator;
import org.wildfly.common.iteration.StringIterator;
import org.wildfly.common.iteration.Utf8EncodingByteIterator;

public abstract class CodePointIterator
implements BiDirIntIterator,
IndexIterator {
    private static final char[] NO_CHARS = new char[0];
    public static final CodePointIterator EMPTY = new CharArrayIterator(0, NO_CHARS, 0);

    CodePointIterator() {
    }

    @Override
    public abstract boolean hasNext();

    @Override
    public abstract boolean hasPrevious();

    @Override
    public abstract int next() throws NoSuchElementException;

    @Override
    public abstract int peekNext() throws NoSuchElementException;

    @Override
    public abstract int previous() throws NoSuchElementException;

    @Override
    public abstract int peekPrevious() throws NoSuchElementException;

    @Override
    public abstract long getIndex();

    public final boolean contentEquals(CodePointIterator other) {
        while (this.hasNext()) {
            if (!other.hasNext()) {
                return false;
            }
            if (this.peekNext() != other.peekNext()) {
                return false;
            }
            this.next();
            other.next();
        }
        return !other.hasNext();
    }

    public boolean contentEquals(String other) {
        return this.contentEquals(CodePointIterator.ofString(other));
    }

    public final CodePointIterator limitedTo(long size) {
        if (size <= 0L || !this.hasNext()) {
            return EMPTY;
        }
        return new LimitedCodePointIterator(this, size);
    }

    public final CodePointIterator delimitedBy(int ... delims) {
        if (delims == null || delims.length == 0 || !this.hasNext()) {
            return EMPTY;
        }
        return new DelimitedCodePointIterator(this, delims);
    }

    public StringBuilder drainTo(StringBuilder b) {
        while (this.hasNext()) {
            b.appendCodePoint(this.next());
        }
        return b;
    }

    public CodePointIterator skipAll() {
        while (this.hasNext()) {
            this.next();
        }
        return this;
    }

    public StringBuilder drainTo(StringBuilder b, String prefix, int delim, int n) {
        int i = 0;
        boolean insertPrefix = prefix != null;
        boolean insertDelim = Character.isValidCodePoint(delim);
        if (this.hasNext()) {
            if (insertPrefix) {
                b.append(prefix);
            }
            b.appendCodePoint(this.next());
            ++i;
            while (this.hasNext()) {
                if (i == n) {
                    if (insertDelim) {
                        b.appendCodePoint(delim);
                    }
                    if (insertPrefix) {
                        b.append(prefix);
                    }
                    b.appendCodePoint(this.next());
                    i = 1;
                    continue;
                }
                b.appendCodePoint(this.next());
                ++i;
            }
        }
        return b;
    }

    public StringBuilder drainTo(StringBuilder b, int delim, int n) {
        return this.drainTo(b, null, delim, n);
    }

    public StringBuilder drainTo(StringBuilder b, String prefix, int n) {
        return this.drainTo(b, prefix, -1, n);
    }

    public String drainToString() {
        return this.hasNext() ? this.drainTo(new StringBuilder()).toString() : "";
    }

    public String drainToString(String prefix, int delim, int n) {
        return this.hasNext() ? this.drainTo(new StringBuilder(), prefix, delim, n).toString() : "";
    }

    public String drainToString(int delim, int n) {
        return this.hasNext() ? this.drainTo(new StringBuilder(), null, delim, n).toString() : "";
    }

    public String drainToString(String prefix, int n) {
        return this.hasNext() ? this.drainTo(new StringBuilder(), prefix, -1, n).toString() : "";
    }

    public ByteIterator base64Decode(Base64Alphabet alphabet, boolean requirePadding) {
        if (!this.hasNext()) {
            return ByteIterator.EMPTY;
        }
        if (alphabet.isLittleEndian()) {
            return new LittleEndianBase64DecodingByteIterator(this, requirePadding, alphabet);
        }
        return new BigEndianBase64DecodingByteIterator(this, requirePadding, alphabet);
    }

    public ByteIterator base32Decode(Base32Alphabet alphabet, boolean requirePadding) {
        if (!this.hasNext()) {
            return ByteIterator.EMPTY;
        }
        if (alphabet.isLittleEndian()) {
            return new LittleEndianBase32DecodingByteIterator(this, requirePadding, alphabet);
        }
        return new BigEndianBase32DecodingByteIterator(this, requirePadding, alphabet);
    }

    public ByteIterator hexDecode() {
        if (!this.hasNext()) {
            return ByteIterator.EMPTY;
        }
        return new Base16DecodingByteIterator(this);
    }

    public ByteIterator base64Decode(Base64Alphabet alphabet) {
        return this.base64Decode(alphabet, true);
    }

    public ByteIterator base64Decode() {
        return this.base64Decode(Base64Alphabet.STANDARD, true);
    }

    public ByteIterator base32Decode(Base32Alphabet alphabet) {
        return this.base32Decode(alphabet, true);
    }

    public ByteIterator base32Decode() {
        return this.base32Decode(Base32Alphabet.STANDARD, true);
    }

    public ByteIterator asLatin1() {
        return new Latin1EncodingByteIterator(this);
    }

    public ByteIterator asUtf8() {
        return this.asUtf8(false);
    }

    public ByteIterator asUtf8(boolean escapeNul) {
        return new Utf8EncodingByteIterator(this, escapeNul);
    }

    public static CodePointIterator ofString(String string2) {
        return CodePointIterator.ofString(string2, 0, string2.length());
    }

    public static CodePointIterator ofString(String string2, int offs, int len) {
        if (len == 0) {
            return EMPTY;
        }
        return new StringIterator(len, string2, offs);
    }

    public static CodePointIterator ofChars(char[] chars2) {
        return CodePointIterator.ofChars(chars2, 0, chars2.length);
    }

    public static CodePointIterator ofChars(char[] chars2, int offs) {
        return CodePointIterator.ofChars(chars2, offs, chars2.length - offs);
    }

    public static CodePointIterator ofChars(char[] chars2, int offs, int len) {
        if (len <= 0) {
            return EMPTY;
        }
        return new CharArrayIterator(len, chars2, offs);
    }

    public static CodePointIterator ofUtf8Bytes(byte[] bytes2) {
        return CodePointIterator.ofUtf8Bytes(bytes2, 0, bytes2.length);
    }

    public static CodePointIterator ofUtf8Bytes(byte[] bytes2, int offs, int len) {
        if (len <= 0) {
            return EMPTY;
        }
        return ByteIterator.ofBytes(bytes2, offs, len).asUtf8String();
    }

    public static CodePointIterator ofLatin1Bytes(byte[] bytes2) {
        return CodePointIterator.ofLatin1Bytes(bytes2, 0, bytes2.length);
    }

    public static CodePointIterator ofLatin1Bytes(byte[] bytes2, int offs, int len) {
        if (len <= 0) {
            return EMPTY;
        }
        return ByteIterator.ofBytes(bytes2, offs, len).asLatin1String();
    }

    public CodePointIterator skipCrLf() {
        return this.skip(value -> value == 10 || value == 13);
    }

    public CodePointIterator skip(IntPredicate predicate) {
        if (!this.hasNext()) {
            return EMPTY;
        }
        return new SkippingCodePointIterator(this, predicate);
    }
}

