/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.ref;

import java.lang.ref.ReferenceQueue;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicInteger;
import org.wildfly.common.Assert;
import org.wildfly.common.ref.CleanerReference;
import org.wildfly.common.ref.Log;
import org.wildfly.common.ref.PhantomReference;
import org.wildfly.common.ref.Reapable;
import org.wildfly.common.ref.Reaper;
import org.wildfly.common.ref.Reference;
import org.wildfly.common.ref.SoftReference;
import org.wildfly.common.ref.StrongReference;
import org.wildfly.common.ref.WeakReference;

public final class References {
    private static final Reference<?, ?> NULL = new Reference<Object, Object>(){

        @Override
        public Object get() {
            return null;
        }

        @Override
        public Object getAttachment() {
            return null;
        }

        @Override
        public void clear() {
        }

        @Override
        public Reference.Type getType() {
            return Reference.Type.NULL;
        }

        public String toString() {
            return "NULL reference";
        }
    };

    private References() {
    }

    public static <T, A> Reference<T, A> create(Reference.Type type2, T value, A attachment, Reaper<T, A> reaper) {
        Assert.checkNotNullParam("type", type2);
        if (value == null) {
            return References.getNullReference();
        }
        switch (type2) {
            case STRONG: {
                return new StrongReference<T, A>(value, attachment);
            }
            case WEAK: {
                return new WeakReference<T, A>(value, attachment, reaper);
            }
            case PHANTOM: {
                return new PhantomReference<T, A>(value, attachment, reaper);
            }
            case SOFT: {
                return new SoftReference<T, A>(value, attachment, reaper);
            }
            case NULL: {
                return References.getNullReference();
            }
        }
        throw Assert.impossibleSwitchCase((Object)type2);
    }

    public static <T, A> Reference<T, A> create(Reference.Type type2, T value, A attachment, ReferenceQueue<? super T> referenceQueue) {
        Assert.checkNotNullParam("type", type2);
        if (referenceQueue == null) {
            return References.create(type2, value, attachment);
        }
        if (value == null) {
            return References.getNullReference();
        }
        switch (type2) {
            case STRONG: {
                return new StrongReference<T, A>(value, attachment);
            }
            case WEAK: {
                return new WeakReference<T, A>(value, attachment, referenceQueue);
            }
            case PHANTOM: {
                return new PhantomReference<T, A>(value, attachment, referenceQueue);
            }
            case SOFT: {
                return new SoftReference<T, A>(value, attachment, referenceQueue);
            }
            case NULL: {
                return References.getNullReference();
            }
        }
        throw Assert.impossibleSwitchCase((Object)type2);
    }

    public static <T, A> Reference<T, A> create(Reference.Type type2, T value, A attachment) {
        Assert.checkNotNullParam("type", type2);
        if (value == null) {
            return References.getNullReference();
        }
        switch (type2) {
            case STRONG: {
                return new StrongReference<T, A>(value, attachment);
            }
            case WEAK: {
                return new WeakReference<T, A>(value, attachment);
            }
            case PHANTOM: {
                return References.getNullReference();
            }
            case SOFT: {
                return new SoftReference<T, A>(value, attachment);
            }
            case NULL: {
                return References.getNullReference();
            }
        }
        throw Assert.impossibleSwitchCase((Object)type2);
    }

    public static <T, A> Reference<T, A> getNullReference() {
        return NULL;
    }

    static final class ReaperThread
    extends Thread {
        static final ReferenceQueue<Object> REAPER_QUEUE = new ReferenceQueue();

        ReaperThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        java.lang.ref.Reference<Object> ref2;
                        if ((ref2 = REAPER_QUEUE.remove()) instanceof CleanerReference) {
                            ((CleanerReference)ref2).clean();
                        }
                        if (!(ref2 instanceof Reapable)) continue;
                        ReaperThread.reap((Reapable)((Object)ref2));
                    }
                }
                catch (InterruptedException ref2) {
                    continue;
                }
                catch (Throwable cause) {
                    Log.log.reapFailed(cause);
                    continue;
                }
                break;
            }
        }

        private static <T, A> void reap(Reapable<T, A> reapable) {
            reapable.getReaper().reap((Reference)((Object)reapable));
        }

        static {
            AtomicInteger cnt = new AtomicInteger(1);
            PrivilegedAction<Void> action = () -> {
                ReaperThread thr = new ReaperThread();
                thr.setName("Reference Reaper #" + cnt.getAndIncrement());
                thr.setDaemon(true);
                thr.start();
                return null;
            };
            for (int i = 0; i < 3; ++i) {
                AccessController.doPrivileged(action);
            }
        }
    }
}

