/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xnio.Property;
import org.xnio.Sequence;
import org.xnio.SequenceOption;
import org.xnio.SingleOption;
import org.xnio.TypeOption;
import org.xnio.TypeSequenceOption;
import org.xnio._private.Messages;

public abstract class Option<T>
implements Serializable {
    private static final long serialVersionUID = -1564427329140182760L;
    private final Class<?> declClass;
    private final String name;
    private static final Map<Class<?>, ValueParser<?>> parsers;
    private static final ValueParser<?> noParser;

    Option(Class<?> declClass, String name2) {
        if (declClass == null) {
            throw Messages.msg.nullParameter("declClass");
        }
        if (name2 == null) {
            throw Messages.msg.nullParameter("name");
        }
        this.declClass = declClass;
        this.name = name2;
    }

    public static <T> Option<T> simple(Class<?> declClass, String name2, Class<T> type2) {
        return new SingleOption<T>(declClass, name2, type2);
    }

    public static <T> Option<Sequence<T>> sequence(Class<?> declClass, String name2, Class<T> elementType) {
        return new SequenceOption<T>(declClass, name2, elementType);
    }

    public static <T> Option<Class<? extends T>> type(Class<?> declClass, String name2, Class<T> declType) {
        return new TypeOption<T>(declClass, name2, declType);
    }

    public static <T> Option<Sequence<Class<? extends T>>> typeSequence(Class<?> declClass, String name2, Class<T> elementDeclType) {
        return new TypeSequenceOption<T>(declClass, name2, elementDeclType);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.declClass.getName() + "." + this.name;
    }

    public static Option<?> fromString(String name2, ClassLoader classLoader) throws IllegalArgumentException {
        Option option;
        Field field;
        Class<?> clazz;
        int lastDot = name2.lastIndexOf(46);
        if (lastDot == -1) {
            throw Messages.msg.invalidOptionName(name2);
        }
        String fieldName = name2.substring(lastDot + 1);
        String className = name2.substring(0, lastDot);
        try {
            clazz = Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException e2) {
            throw Messages.msg.optionClassNotFound(className, classLoader);
        }
        try {
            field = clazz.getField(fieldName);
        }
        catch (NoSuchFieldException e3) {
            throw Messages.msg.noField(fieldName, clazz);
        }
        int modifiers = field.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            throw Messages.msg.fieldNotAccessible(fieldName, clazz);
        }
        if (!Modifier.isStatic(modifiers)) {
            throw Messages.msg.fieldNotStatic(fieldName, clazz);
        }
        try {
            option = (Option)field.get(null);
        }
        catch (IllegalAccessException e4) {
            throw Messages.msg.fieldNotAccessible(fieldName, clazz);
        }
        if (option == null) {
            throw Messages.msg.invalidNullOption(name2);
        }
        return option;
    }

    public abstract T cast(Object var1) throws ClassCastException;

    public final T cast(Object o, T defaultVal) throws ClassCastException {
        return o == null ? defaultVal : this.cast(o);
    }

    public abstract T parseValue(String var1, ClassLoader var2) throws IllegalArgumentException;

    protected final Object readResolve() throws ObjectStreamException {
        try {
            Field field = this.declClass.getField(this.name);
            int modifiers = field.getModifiers();
            if (!Modifier.isPublic(modifiers)) {
                throw new InvalidObjectException("Invalid Option instance (the field is not public)");
            }
            if (!Modifier.isStatic(modifiers)) {
                throw new InvalidObjectException("Invalid Option instance (the field is not static)");
            }
            Option option = (Option)field.get(null);
            if (option == null) {
                throw new InvalidObjectException("Invalid null Option");
            }
            return option;
        }
        catch (NoSuchFieldException e2) {
            throw new InvalidObjectException("Invalid Option instance (no matching field)");
        }
        catch (IllegalAccessException e3) {
            throw new InvalidObjectException("Invalid Option instance (Illegal access on field get)");
        }
    }

    public static SetBuilder setBuilder() {
        return new SetBuilder();
    }

    static <T> ValueParser<Class<? extends T>> getClassParser(final Class<T> argType) {
        return new ValueParser<Class<? extends T>>(){

            @Override
            public Class<? extends T> parseValue(String string2, ClassLoader classLoader) throws IllegalArgumentException {
                try {
                    return Class.forName(string2, false, classLoader).asSubclass(argType);
                }
                catch (ClassNotFoundException e2) {
                    throw Messages.msg.classNotFound(string2, e2);
                }
                catch (ClassCastException e3) {
                    throw Messages.msg.classNotInstance(string2, argType);
                }
            }
        };
    }

    static <T, E extends Enum<E>> ValueParser<T> getEnumParser(final Class<T> enumType) {
        return new ValueParser<T>(){

            @Override
            public T parseValue(String string2, ClassLoader classLoader) throws IllegalArgumentException {
                return enumType.cast(Enum.valueOf(Option.asEnum(enumType), string2.trim()));
            }
        };
    }

    private static <T, E extends Enum<E>> Class<E> asEnum(Class<T> enumType) {
        return enumType;
    }

    static <T> ValueParser<T> getParser(Class<T> argType) {
        if (argType.isEnum()) {
            return Option.getEnumParser(argType);
        }
        ValueParser<?> value = parsers.get(argType);
        return value == null ? noParser : value;
    }

    static {
        noParser = new ValueParser<Object>(){

            @Override
            public Object parseValue(String string2, ClassLoader classLoader) throws IllegalArgumentException {
                throw Messages.msg.noOptionParser();
            }
        };
        HashMap map2 = new HashMap();
        map2.put(Byte.class, new ValueParser<Byte>(){

            @Override
            public Byte parseValue(String string2, ClassLoader classLoader) throws IllegalArgumentException {
                return Byte.decode(string2.trim());
            }
        });
        map2.put(Short.class, new ValueParser<Short>(){

            @Override
            public Short parseValue(String string2, ClassLoader classLoader) throws IllegalArgumentException {
                return Short.decode(string2.trim());
            }
        });
        map2.put(Integer.class, new ValueParser<Integer>(){

            @Override
            public Integer parseValue(String string2, ClassLoader classLoader) throws IllegalArgumentException {
                return Integer.decode(string2.trim());
            }
        });
        map2.put(Long.class, new ValueParser<Long>(){

            @Override
            public Long parseValue(String string2, ClassLoader classLoader) throws IllegalArgumentException {
                return Long.decode(string2.trim());
            }
        });
        map2.put(String.class, new ValueParser<String>(){

            @Override
            public String parseValue(String string2, ClassLoader classLoader) throws IllegalArgumentException {
                return string2.trim();
            }
        });
        map2.put(Boolean.class, new ValueParser<Boolean>(){

            @Override
            public Boolean parseValue(String string2, ClassLoader classLoader) throws IllegalArgumentException {
                return Boolean.valueOf(string2.trim());
            }
        });
        map2.put(Property.class, new ValueParser<Object>(){

            @Override
            public Object parseValue(String string2, ClassLoader classLoader) throws IllegalArgumentException {
                int idx = string2.indexOf(61);
                if (idx == -1) {
                    throw Messages.msg.invalidOptionPropertyFormat(string2);
                }
                return Property.of(string2.substring(0, idx), string2.substring(idx + 1, string2.length()));
            }
        });
        parsers = map2;
    }

    static interface ValueParser<T> {
        public T parseValue(String var1, ClassLoader var2) throws IllegalArgumentException;
    }

    public static class SetBuilder {
        private List<Option<?>> optionSet = new ArrayList();

        SetBuilder() {
        }

        public SetBuilder add(Option<?> option) {
            if (option == null) {
                throw Messages.msg.nullParameter("option");
            }
            this.optionSet.add(option);
            return this;
        }

        public SetBuilder add(Option<?> option1, Option<?> option2) {
            if (option1 == null) {
                throw Messages.msg.nullParameter("option1");
            }
            if (option2 == null) {
                throw Messages.msg.nullParameter("option2");
            }
            this.optionSet.add(option1);
            this.optionSet.add(option2);
            return this;
        }

        public SetBuilder add(Option<?> option1, Option<?> option2, Option<?> option3) {
            if (option1 == null) {
                throw Messages.msg.nullParameter("option1");
            }
            if (option2 == null) {
                throw Messages.msg.nullParameter("option2");
            }
            if (option3 == null) {
                throw Messages.msg.nullParameter("option3");
            }
            this.optionSet.add(option1);
            this.optionSet.add(option2);
            this.optionSet.add(option3);
            return this;
        }

        public SetBuilder add(Option<?> ... options) {
            if (options == null) {
                throw Messages.msg.nullParameter("options");
            }
            for (Option<?> option : options) {
                this.add(option);
            }
            return this;
        }

        public SetBuilder addAll(Collection<Option<?>> options) {
            if (options == null) {
                throw Messages.msg.nullParameter("option");
            }
            for (Option<?> option : options) {
                this.add(option);
            }
            return this;
        }

        public Set<Option<?>> create() {
            return Collections.unmodifiableSet(new LinkedHashSet(this.optionSet));
        }
    }
}

