/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import org.wildfly.client.config.ClientConfiguration;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.client.config.ConfigurationXMLStreamReader;
import org.wildfly.common.net.CidrAddress;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

final class XnioXmlParser {
    private static final String NS_XNIO_3_5 = "urn:xnio:3.5";

    XnioXmlParser() {
    }

    static XnioWorker parseWorker(Xnio xnio) throws ConfigXMLParseException, IOException {
        return XnioXmlParser.parseWorker(xnio, ClientConfiguration.getInstance());
    }

    static XnioWorker parseWorker(Xnio xnio, ClientConfiguration clientConfiguration) throws ConfigXMLParseException, IOException {
        XnioWorker.Builder builder = xnio.createWorkerBuilder();
        if (clientConfiguration == null) {
            return null;
        }
        builder.setDaemon(true);
        ConfigurationXMLStreamReader reader2 = clientConfiguration.readConfiguration(Collections.singleton(NS_XNIO_3_5));
        XnioXmlParser.parseDocument(reader2, builder);
        return builder.build();
    }

    private static void parseDocument(ConfigurationXMLStreamReader reader2, XnioWorker.Builder workerBuilder) throws ConfigXMLParseException {
        if (reader2.hasNext()) {
            block0 : switch (reader2.nextTag()) {
                case 1: {
                    XnioXmlParser.checkElementNamespace(reader2);
                    switch (reader2.getLocalName()) {
                        case "worker": {
                            XnioXmlParser.parseWorkerElement(reader2, workerBuilder);
                            break block0;
                        }
                    }
                    throw reader2.unexpectedElement();
                }
                default: {
                    throw reader2.unexpectedContent();
                }
            }
        }
    }

    private static void parseWorkerElement(ConfigurationXMLStreamReader reader2, XnioWorker.Builder workerBuilder) throws ConfigXMLParseException {
        XnioXmlParser.requireNoAttributes(reader2);
        int foundBits = 0;
        while (reader2.hasNext()) {
            block0 : switch (reader2.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    XnioXmlParser.checkElementNamespace(reader2);
                    switch (reader2.getLocalName()) {
                        case "daemon-threads": {
                            if (XnioXmlParser.isSet(foundBits, 0)) {
                                throw reader2.unexpectedElement();
                            }
                            foundBits = XnioXmlParser.setBit(foundBits, 0);
                            XnioXmlParser.parseDaemonThreads(reader2, workerBuilder);
                            break block0;
                        }
                        case "worker-name": {
                            if (XnioXmlParser.isSet(foundBits, 1)) {
                                throw reader2.unexpectedElement();
                            }
                            foundBits = XnioXmlParser.setBit(foundBits, 1);
                            XnioXmlParser.parseWorkerName(reader2, workerBuilder);
                            break block0;
                        }
                        case "pool-size": {
                            if (XnioXmlParser.isSet(foundBits, 2)) {
                                throw reader2.unexpectedElement();
                            }
                            foundBits = XnioXmlParser.setBit(foundBits, 2);
                            XnioXmlParser.parsePoolSize(reader2, workerBuilder);
                            break block0;
                        }
                        case "task-keepalive": {
                            if (XnioXmlParser.isSet(foundBits, 3)) {
                                throw reader2.unexpectedElement();
                            }
                            foundBits = XnioXmlParser.setBit(foundBits, 3);
                            XnioXmlParser.parseTaskKeepalive(reader2, workerBuilder);
                            break block0;
                        }
                        case "io-threads": {
                            if (XnioXmlParser.isSet(foundBits, 4)) {
                                throw reader2.unexpectedElement();
                            }
                            foundBits = XnioXmlParser.setBit(foundBits, 4);
                            XnioXmlParser.parseIoThreads(reader2, workerBuilder);
                            break block0;
                        }
                        case "stack-size": {
                            if (XnioXmlParser.isSet(foundBits, 5)) {
                                throw reader2.unexpectedElement();
                            }
                            foundBits = XnioXmlParser.setBit(foundBits, 5);
                            XnioXmlParser.parseStackSize(reader2, workerBuilder);
                            break block0;
                        }
                        case "outbound-bind-addresses": {
                            if (XnioXmlParser.isSet(foundBits, 6)) {
                                throw reader2.unexpectedElement();
                            }
                            foundBits = XnioXmlParser.setBit(foundBits, 6);
                            XnioXmlParser.parseOutboundBindAddresses(reader2, workerBuilder);
                            break block0;
                        }
                    }
                    throw reader2.unexpectedElement();
                }
            }
        }
        throw reader2.unexpectedDocumentEnd();
    }

    private static void parseDaemonThreads(ConfigurationXMLStreamReader reader2, XnioWorker.Builder workerBuilder) throws ConfigXMLParseException {
        XnioXmlParser.requireSingleAttribute(reader2, "value");
        boolean daemon = reader2.getBooleanAttributeValueResolved(0);
        if (!reader2.hasNext()) {
            throw reader2.unexpectedDocumentEnd();
        }
        if (reader2.nextTag() != 2) {
            throw reader2.unexpectedElement();
        }
        workerBuilder.setDaemon(daemon);
    }

    private static void parseWorkerName(ConfigurationXMLStreamReader reader2, XnioWorker.Builder workerBuilder) throws ConfigXMLParseException {
        XnioXmlParser.requireSingleAttribute(reader2, "value");
        String name2 = reader2.getAttributeValueResolved(0);
        if (!reader2.hasNext()) {
            throw reader2.unexpectedDocumentEnd();
        }
        if (reader2.nextTag() != 2) {
            throw reader2.unexpectedElement();
        }
        workerBuilder.setWorkerName(name2);
    }

    private static void parsePoolSize(ConfigurationXMLStreamReader reader2, XnioWorker.Builder workerBuilder) throws ConfigXMLParseException {
        XnioXmlParser.requireSingleAttribute(reader2, "max-threads");
        int threadCount = reader2.getIntAttributeValueResolved(0);
        if (!reader2.hasNext()) {
            throw reader2.unexpectedDocumentEnd();
        }
        if (reader2.nextTag() != 2) {
            throw reader2.unexpectedElement();
        }
        workerBuilder.setCoreWorkerPoolSize(threadCount);
        workerBuilder.setMaxWorkerPoolSize(threadCount);
    }

    private static void parseTaskKeepalive(ConfigurationXMLStreamReader reader2, XnioWorker.Builder workerBuilder) throws ConfigXMLParseException {
        XnioXmlParser.requireSingleAttribute(reader2, "value");
        int duration = reader2.getIntAttributeValueResolved(0);
        if (!reader2.hasNext()) {
            throw reader2.unexpectedDocumentEnd();
        }
        if (reader2.nextTag() != 2) {
            throw reader2.unexpectedElement();
        }
        workerBuilder.setWorkerKeepAlive(duration);
    }

    private static void parseIoThreads(ConfigurationXMLStreamReader reader2, XnioWorker.Builder workerBuilder) throws ConfigXMLParseException {
        XnioXmlParser.requireSingleAttribute(reader2, "value");
        int threadCount = reader2.getIntAttributeValueResolved(0);
        if (!reader2.hasNext()) {
            throw reader2.unexpectedDocumentEnd();
        }
        if (reader2.nextTag() != 2) {
            throw reader2.unexpectedElement();
        }
        workerBuilder.setWorkerIoThreads(threadCount);
    }

    private static void parseStackSize(ConfigurationXMLStreamReader reader2, XnioWorker.Builder workerBuilder) throws ConfigXMLParseException {
        XnioXmlParser.requireSingleAttribute(reader2, "value");
        long stackSize = reader2.getLongAttributeValueResolved(0);
        if (!reader2.hasNext()) {
            throw reader2.unexpectedDocumentEnd();
        }
        if (reader2.nextTag() != 2) {
            throw reader2.unexpectedElement();
        }
        workerBuilder.setWorkerStackSize(stackSize);
    }

    private static void parseOutboundBindAddresses(ConfigurationXMLStreamReader reader2, XnioWorker.Builder workerBuilder) throws ConfigXMLParseException {
        XnioXmlParser.requireNoAttributes(reader2);
        while (true) {
            if (!reader2.hasNext()) {
                throw reader2.unexpectedDocumentEnd();
            }
            if (reader2.nextTag() != 1) break;
            XnioXmlParser.checkElementNamespace(reader2);
            if (!reader2.getLocalName().equals("bind-address")) {
                throw reader2.unexpectedElement();
            }
            XnioXmlParser.parseBindAddress(reader2, workerBuilder);
        }
        assert (reader2.getEventType() == 2);
    }

    private static void parseBindAddress(ConfigurationXMLStreamReader reader2, XnioWorker.Builder workerBuilder) throws ConfigXMLParseException {
        int cnt = reader2.getAttributeCount();
        InetAddress address = null;
        int port = 0;
        CidrAddress match = null;
        block10: for (int i = 0; i < cnt; ++i) {
            XnioXmlParser.checkAttributeNamespace(reader2, i);
            switch (reader2.getAttributeLocalName(i)) {
                case "match": {
                    match = reader2.getCidrAddressAttributeValueResolved(i);
                    continue block10;
                }
                case "bind-address": {
                    address = reader2.getInetAddressAttributeValueResolved(i);
                    continue block10;
                }
                case "bind-port": {
                    port = reader2.getIntAttributeValueResolved(i, 0, 65535);
                    continue block10;
                }
                default: {
                    throw reader2.unexpectedAttribute(i);
                }
            }
        }
        if (match == null) {
            throw reader2.missingRequiredAttribute(null, "match");
        }
        if (address == null) {
            throw reader2.missingRequiredAttribute(null, "bind-address");
        }
        workerBuilder.addBindAddressConfiguration(match, new InetSocketAddress(address, port));
        if (!reader2.hasNext()) {
            throw reader2.unexpectedDocumentEnd();
        }
        if (reader2.nextTag() != 2) {
            throw reader2.unexpectedElement();
        }
    }

    private static void checkElementNamespace(ConfigurationXMLStreamReader reader2) throws ConfigXMLParseException {
        if (!reader2.getNamespaceURI().equals(NS_XNIO_3_5)) {
            throw reader2.unexpectedElement();
        }
    }

    private static void checkAttributeNamespace(ConfigurationXMLStreamReader reader2, int idx) throws ConfigXMLParseException {
        String attributeNamespace = reader2.getAttributeNamespace(idx);
        if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
            throw reader2.unexpectedAttribute(idx);
        }
    }

    private static void requireNoAttributes(ConfigurationXMLStreamReader reader2) throws ConfigXMLParseException {
        int attributeCount = reader2.getAttributeCount();
        if (attributeCount > 0) {
            throw reader2.unexpectedAttribute(0);
        }
    }

    private static void requireSingleAttribute(ConfigurationXMLStreamReader reader2, String attributeName) throws ConfigXMLParseException {
        int attributeCount = reader2.getAttributeCount();
        if (attributeCount < 1) {
            throw reader2.missingRequiredAttribute("", attributeName);
        }
        XnioXmlParser.checkAttributeNamespace(reader2, 0);
        if (!reader2.getAttributeLocalName(0).equals(attributeName)) {
            throw reader2.unexpectedAttribute(0);
        }
        if (attributeCount > 1) {
            throw reader2.unexpectedAttribute(1);
        }
    }

    private static boolean isSet(int var, int bit) {
        return (var & 1 << bit) != 0;
    }

    private static int setBit(int var, int bit) {
        return var | 1 << bit;
    }
}

