/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio._private.Messages;
import org.xnio.channels.AssembledChannel;
import org.xnio.channels.CloseableChannel;
import org.xnio.channels.MessageChannel;
import org.xnio.channels.ReadableMessageChannel;
import org.xnio.channels.WritableMessageChannel;

public class AssembledMessageChannel
implements MessageChannel {
    private final CloseableChannel closeable;
    private final ReadableMessageChannel readable;
    private final WritableMessageChannel writable;
    private final ChannelListener.Setter<AssembledMessageChannel> readSetter;
    private final ChannelListener.Setter<AssembledMessageChannel> writeSetter;
    private final ChannelListener.Setter<AssembledMessageChannel> closeSetter;

    public AssembledMessageChannel(CloseableChannel closeable, ReadableMessageChannel readable, WritableMessageChannel writable) {
        if (readable.getWorker() != writable.getWorker() || readable.getWorker() != closeable.getWorker()) {
            throw Messages.msg.differentWorkers();
        }
        this.closeable = closeable;
        this.readable = readable;
        this.writable = writable;
        this.readSetter = ChannelListeners.getDelegatingSetter(readable.getReadSetter(), this);
        this.writeSetter = ChannelListeners.getDelegatingSetter(writable.getWriteSetter(), this);
        this.closeSetter = ChannelListeners.getDelegatingSetter(closeable.getCloseSetter(), this);
    }

    public AssembledMessageChannel(ReadableMessageChannel readable, WritableMessageChannel writable) {
        this(new AssembledChannel(readable, writable), readable, writable);
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.readable.getIoThread();
    }

    public ChannelListener.Setter<? extends AssembledMessageChannel> getReadSetter() {
        return this.readSetter;
    }

    @Override
    public void suspendReads() {
        this.readable.suspendReads();
    }

    @Override
    public void resumeReads() {
        this.readable.resumeReads();
    }

    @Override
    public boolean isReadResumed() {
        return this.readable.isReadResumed();
    }

    @Override
    public void wakeupReads() {
        this.readable.wakeupReads();
    }

    @Override
    public void shutdownReads() throws IOException {
        this.readable.shutdownReads();
    }

    @Override
    public void awaitReadable() throws IOException {
        this.readable.awaitReadable();
    }

    @Override
    public void awaitReadable(long time2, TimeUnit timeUnit) throws IOException {
        this.readable.awaitReadable(time2, timeUnit);
    }

    @Override
    @Deprecated
    public XnioExecutor getReadThread() {
        return this.readable.getReadThread();
    }

    @Override
    public int receive(ByteBuffer buffer) throws IOException {
        return this.readable.receive(buffer);
    }

    @Override
    public long receive(ByteBuffer[] buffers) throws IOException {
        return this.readable.receive(buffers);
    }

    @Override
    public long receive(ByteBuffer[] buffers, int offs, int len) throws IOException {
        return this.readable.receive(buffers, offs, len);
    }

    public ChannelListener.Setter<? extends AssembledMessageChannel> getWriteSetter() {
        return this.writeSetter;
    }

    @Override
    public void suspendWrites() {
        this.writable.suspendWrites();
    }

    @Override
    public void resumeWrites() {
        this.writable.resumeWrites();
    }

    @Override
    public boolean isWriteResumed() {
        return this.writable.isWriteResumed();
    }

    @Override
    public void wakeupWrites() {
        this.writable.wakeupWrites();
    }

    @Override
    public void shutdownWrites() throws IOException {
        this.writable.shutdownWrites();
    }

    @Override
    public void awaitWritable() throws IOException {
        this.writable.awaitWritable();
    }

    @Override
    public void awaitWritable(long time2, TimeUnit timeUnit) throws IOException {
        this.writable.awaitWritable(time2, timeUnit);
    }

    @Override
    @Deprecated
    public XnioExecutor getWriteThread() {
        return this.writable.getWriteThread();
    }

    @Override
    public boolean send(ByteBuffer buffer) throws IOException {
        return this.writable.send(buffer);
    }

    @Override
    public boolean send(ByteBuffer[] buffers) throws IOException {
        return this.writable.send(buffers);
    }

    @Override
    public boolean send(ByteBuffer[] buffers, int offs, int len) throws IOException {
        return this.writable.send(buffers, offs, len);
    }

    @Override
    public boolean sendFinal(ByteBuffer buffer) throws IOException {
        return this.writable.sendFinal(buffer);
    }

    @Override
    public boolean sendFinal(ByteBuffer[] buffers) throws IOException {
        return this.writable.sendFinal(buffers);
    }

    @Override
    public boolean sendFinal(ByteBuffer[] buffers, int offs, int len) throws IOException {
        return this.writable.sendFinal(buffers, offs, len);
    }

    @Override
    public boolean flush() throws IOException {
        return this.writable.flush();
    }

    public ChannelListener.Setter<? extends AssembledMessageChannel> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public XnioWorker getWorker() {
        return this.closeable.getWorker();
    }

    @Override
    public void close() throws IOException {
        this.closeable.close();
    }

    @Override
    public boolean isOpen() {
        return this.closeable.isOpen();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.closeable.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return this.closeable.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return this.closeable.setOption(option, value);
    }
}

