/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.xnio.Buffers;
import org.xnio.Pooled;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.conduits.AbstractStreamSourceConduit;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.StreamSourceConduit;

public final class BufferedStreamSourceConduit
extends AbstractStreamSourceConduit<StreamSourceConduit> {
    private final Pooled<ByteBuffer> pooledBuffer;

    public BufferedStreamSourceConduit(StreamSourceConduit next2, Pooled<ByteBuffer> pooledBuffer) {
        super(next2);
        this.pooledBuffer = pooledBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long transferTo(long position, long count2, FileChannel target) throws IOException {
        long l;
        ByteBuffer buffer = this.pooledBuffer.getResource();
        int lim = buffer.limit();
        int pos = buffer.position();
        int rem2 = lim - pos;
        if (rem2 <= 0) return super.transferTo(position, count2, target);
        if ((long)rem2 <= count2) return target.write(buffer, position);
        buffer.limit(pos + (int)count2);
        try {
            l = target.write(buffer, position);
            buffer.limit(lim);
        }
        catch (Throwable throwable) {
            try {
                buffer.limit(lim);
                throw throwable;
            }
            catch (IllegalStateException ignored) {
                return 0L;
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferTo(long count2, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        try {
            ByteBuffer buffer = this.pooledBuffer.getResource();
            int lim = buffer.limit();
            int pos = buffer.position();
            int rem2 = lim - pos;
            throughBuffer.clear();
            long t = 0L;
            while (rem2 > 0) {
                int res;
                if ((long)rem2 > count2) {
                    buffer.limit(pos + (int)count2);
                    try {
                        res = target.write(buffer);
                        t += (long)res;
                    }
                    finally {
                        buffer.limit(lim);
                    }
                } else {
                    res = target.write(buffer);
                    t += (long)res;
                }
                if (res == 0) {
                    return t;
                }
                pos = buffer.position();
                rem2 = lim - pos;
            }
            long lres = Conduits.transfer((StreamSourceConduit)this.next, count2, throughBuffer, target);
            if (lres > 0L) {
                t += lres;
            }
            return t == 0L && lres == -1L ? -1L : t;
        }
        catch (IllegalStateException ignored) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        try {
            ByteBuffer buffer = this.pooledBuffer.getResource();
            int lim = buffer.limit();
            int pos = buffer.position();
            int rem2 = lim - pos;
            if (rem2 > 0) {
                return Buffers.copy(dst, buffer);
            }
            int dstRem = dst.remaining();
            buffer.clear();
            try {
                long rres = ((StreamSourceConduit)this.next).read(new ByteBuffer[]{dst, buffer}, 0, 2);
                if (rres != -1L) return dst.remaining() - dstRem;
                int n = -1;
                return n;
            }
            finally {
                buffer.flip();
            }
        }
        catch (IllegalStateException ignored) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long read(ByteBuffer[] dsts, int offs, int len) throws IOException {
        if (len == 0) {
            return 0L;
        }
        if (len == 1) {
            return this.read(dsts[offs]);
        }
        try {
            ByteBuffer buffer = this.pooledBuffer.getResource();
            int lim = buffer.limit();
            int pos = buffer.position();
            int rem2 = lim - pos;
            if (rem2 > 0) {
                return Buffers.copy(dsts, offs, len, buffer);
            }
            long dstRem = Buffers.remaining(dsts, offs, len);
            buffer.clear();
            try {
                ByteBuffer[] buffers = Arrays.copyOfRange(dsts, offs, offs + len + 1);
                buffers[buffers.length - 1] = buffer;
                long rres = ((StreamSourceConduit)this.next).read(buffers, 0, buffers.length);
                if (rres != -1L) return Buffers.remaining(dsts, offs, len) - dstRem;
                long l = -1L;
                return l;
            }
            finally {
                buffer.flip();
            }
        }
        catch (IllegalStateException ignored) {
            return -1L;
        }
    }

    @Override
    public void terminateReads() throws IOException {
        this.pooledBuffer.free();
        super.terminateReads();
    }
}

