/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.CloseListenerSettable;
import org.xnio.channels.Configurable;
import org.xnio.channels.ReadListenerSettable;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ReadReadyHandler;
import org.xnio.conduits.StreamSourceConduit;

public final class ConduitStreamSourceChannel
implements StreamSourceChannel,
ReadListenerSettable<ConduitStreamSourceChannel>,
CloseListenerSettable<ConduitStreamSourceChannel>,
Cloneable {
    private final Configurable configurable;
    private StreamSourceConduit conduit;
    private ChannelListener<? super ConduitStreamSourceChannel> readListener;
    private ChannelListener<? super ConduitStreamSourceChannel> closeListener;

    public ConduitStreamSourceChannel(Configurable configurable, StreamSourceConduit conduit) {
        this.configurable = configurable;
        this.conduit = conduit;
        conduit.setReadReadyHandler(new ReadReadyHandler.ChannelListenerHandler<ConduitStreamSourceChannel>(this));
    }

    public StreamSourceConduit getConduit() {
        return this.conduit;
    }

    public void setConduit(StreamSourceConduit conduit) {
        this.conduit = conduit;
    }

    @Override
    public boolean isOpen() {
        return !this.conduit.isReadShutdown();
    }

    @Override
    public long transferTo(long position, long count2, FileChannel target) throws IOException {
        return this.conduit.transferTo(position, count2, target);
    }

    @Override
    public long transferTo(long count2, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        return this.conduit.transferTo(count2, throughBuffer, target);
    }

    @Override
    public void setReadListener(ChannelListener<? super ConduitStreamSourceChannel> readListener) {
        this.readListener = readListener;
    }

    @Override
    public ChannelListener<? super ConduitStreamSourceChannel> getReadListener() {
        return this.readListener;
    }

    @Override
    public void setCloseListener(ChannelListener<? super ConduitStreamSourceChannel> closeListener) {
        this.closeListener = closeListener;
    }

    @Override
    public ChannelListener<? super ConduitStreamSourceChannel> getCloseListener() {
        return this.closeListener;
    }

    public ChannelListener.Setter<ConduitStreamSourceChannel> getReadSetter() {
        return new ReadListenerSettable.Setter<ConduitStreamSourceChannel>(this);
    }

    public ChannelListener.Setter<ConduitStreamSourceChannel> getCloseSetter() {
        return new CloseListenerSettable.Setter<ConduitStreamSourceChannel>(this);
    }

    @Override
    public XnioWorker getWorker() {
        return this.conduit.getWorker();
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.conduit.read(dsts, offset, length);
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.conduit.read(dsts, 0, dsts.length);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.conduit.read(dst);
    }

    @Override
    public void suspendReads() {
        this.conduit.suspendReads();
    }

    @Override
    public void resumeReads() {
        this.conduit.resumeReads();
    }

    @Override
    public boolean isReadResumed() {
        return this.conduit.isReadResumed();
    }

    @Override
    public void wakeupReads() {
        this.conduit.wakeupReads();
    }

    @Override
    public void shutdownReads() throws IOException {
        this.conduit.terminateReads();
    }

    @Override
    public void awaitReadable() throws IOException {
        this.conduit.awaitReadable();
    }

    @Override
    public void awaitReadable(long time2, TimeUnit timeUnit) throws IOException {
        this.conduit.awaitReadable(time2, timeUnit);
    }

    @Override
    @Deprecated
    public XnioExecutor getReadThread() {
        return this.conduit.getReadThread();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.conduit.getReadThread();
    }

    @Override
    public void close() throws IOException {
        this.conduit.terminateReads();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.configurable.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return this.configurable.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return this.configurable.setOption(option, value);
    }

    public ConduitStreamSourceChannel clone() {
        try {
            return (ConduitStreamSourceChannel)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new IllegalStateException(e2);
        }
    }
}

