/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.CloseListenerSettable;
import org.xnio.channels.Configurable;
import org.xnio.channels.WritableMessageChannel;
import org.xnio.channels.WriteListenerSettable;
import org.xnio.conduits.MessageSinkConduit;
import org.xnio.conduits.WriteReadyHandler;

public final class ConduitWritableMessageChannel
implements WritableMessageChannel,
WriteListenerSettable<ConduitWritableMessageChannel>,
CloseListenerSettable<ConduitWritableMessageChannel>,
Cloneable {
    private final Configurable configurable;
    private MessageSinkConduit conduit;
    private ChannelListener<? super ConduitWritableMessageChannel> writeListener;
    private ChannelListener<? super ConduitWritableMessageChannel> closeListener;

    public ConduitWritableMessageChannel(Configurable configurable, MessageSinkConduit conduit) {
        this.configurable = configurable;
        this.conduit = conduit;
        conduit.setWriteReadyHandler(new WriteReadyHandler.ChannelListenerHandler<ConduitWritableMessageChannel>(this));
    }

    public MessageSinkConduit getConduit() {
        return this.conduit;
    }

    public void setConduit(MessageSinkConduit conduit) {
        this.conduit = conduit;
    }

    @Override
    public ChannelListener<? super ConduitWritableMessageChannel> getWriteListener() {
        return this.writeListener;
    }

    @Override
    public void setWriteListener(ChannelListener<? super ConduitWritableMessageChannel> writeListener) {
        this.writeListener = writeListener;
    }

    @Override
    public ChannelListener<? super ConduitWritableMessageChannel> getCloseListener() {
        return this.closeListener;
    }

    @Override
    public void setCloseListener(ChannelListener<? super ConduitWritableMessageChannel> closeListener) {
        this.closeListener = closeListener;
    }

    public ChannelListener.Setter<ConduitWritableMessageChannel> getWriteSetter() {
        return new WriteListenerSettable.Setter<ConduitWritableMessageChannel>(this);
    }

    public ChannelListener.Setter<ConduitWritableMessageChannel> getCloseSetter() {
        return new CloseListenerSettable.Setter<ConduitWritableMessageChannel>(this);
    }

    @Override
    public void suspendWrites() {
        this.conduit.suspendWrites();
    }

    @Override
    public void resumeWrites() {
        this.conduit.resumeWrites();
    }

    @Override
    public void wakeupWrites() {
        this.conduit.wakeupWrites();
    }

    @Override
    public boolean isWriteResumed() {
        return this.conduit.isWriteResumed();
    }

    @Override
    public void awaitWritable() throws IOException {
        this.conduit.awaitWritable();
    }

    @Override
    public void awaitWritable(long time2, TimeUnit timeUnit) throws IOException {
        this.conduit.awaitWritable(time2, timeUnit);
    }

    @Override
    public boolean send(ByteBuffer dst) throws IOException {
        return this.conduit.send(dst);
    }

    @Override
    public boolean send(ByteBuffer[] srcs) throws IOException {
        return this.conduit.send(srcs, 0, srcs.length);
    }

    @Override
    public boolean send(ByteBuffer[] dsts, int offs, int len) throws IOException {
        return this.conduit.send(dsts, offs, len);
    }

    @Override
    public boolean sendFinal(ByteBuffer buffer) throws IOException {
        return this.conduit.sendFinal(buffer);
    }

    @Override
    public boolean sendFinal(ByteBuffer[] buffers) throws IOException {
        return this.conduit.sendFinal(buffers, 0, buffers.length);
    }

    @Override
    public boolean sendFinal(ByteBuffer[] buffers, int offs, int len) throws IOException {
        return this.conduit.sendFinal(buffers, offs, len);
    }

    @Override
    public boolean flush() throws IOException {
        return this.conduit.flush();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.configurable.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return this.configurable.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return this.configurable.setOption(option, value);
    }

    @Override
    public void shutdownWrites() throws IOException {
        this.conduit.terminateWrites();
    }

    @Override
    public boolean isOpen() {
        return !this.conduit.isWriteShutdown();
    }

    @Override
    public void close() throws IOException {
        this.conduit.truncateWrites();
    }

    @Override
    @Deprecated
    public XnioExecutor getWriteThread() {
        return this.conduit.getWriteThread();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.conduit.getWriteThread();
    }

    @Override
    public XnioWorker getWorker() {
        return this.conduit.getWorker();
    }

    public ConduitWritableMessageChannel clone() {
        try {
            return (ConduitWritableMessageChannel)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new IllegalStateException(e2);
        }
    }
}

