/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.zip.Deflater;
import org.xnio.Buffers;
import org.xnio._private.Messages;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.StreamSinkConduit;

public final class DeflatingStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit>
implements StreamSinkConduit {
    private static final byte[] NO_BYTES = new byte[0];
    private final Deflater deflater;
    private final ByteBuffer outBuffer;

    public DeflatingStreamSinkConduit(StreamSinkConduit next2, Deflater deflater) {
        super(next2);
        this.deflater = deflater;
        this.outBuffer = ByteBuffer.allocate(16384);
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count2) throws IOException {
        return src.transferTo(position, count2, new ConduitWritableByteChannel(this));
    }

    @Override
    public long transferFrom(StreamSourceChannel source2, long count2, ByteBuffer throughBuffer) throws IOException {
        return Conduits.transfer(source2, count2, throughBuffer, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        int rem2;
        ByteBuffer outBuffer = this.outBuffer;
        byte[] outArray = outBuffer.array();
        Deflater deflater = this.deflater;
        assert (outBuffer.arrayOffset() == 0);
        int cnt = 0;
        while ((rem2 = src.remaining()) > 0) {
            int t;
            int c1;
            if (!outBuffer.hasRemaining()) {
                outBuffer.flip();
                try {
                    if (((StreamSinkConduit)this.next).write(outBuffer) == 0) {
                        int n = cnt;
                        return n;
                    }
                }
                finally {
                    outBuffer.compact();
                }
            }
            int pos = src.position();
            if (src.hasArray()) {
                byte[] array2 = src.array();
                int arrayOffset = src.arrayOffset();
                deflater.setInput(array2, arrayOffset + pos, rem2);
                c1 = deflater.getTotalIn();
                int dc = deflater.deflate(outArray, outBuffer.position(), outBuffer.remaining());
                outBuffer.position(outBuffer.position() + dc);
                t = deflater.getTotalIn() - c1;
                src.position(pos + t);
                cnt += t;
                continue;
            }
            byte[] bytes2 = Buffers.take(src);
            deflater.setInput(bytes2);
            c1 = deflater.getTotalIn();
            int dc = deflater.deflate(outArray, outBuffer.position(), outBuffer.remaining());
            outBuffer.position(outBuffer.position() + dc);
            t = deflater.getTotalIn() - c1;
            src.position(pos + t);
            cnt += t;
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        ByteBuffer outBuffer = this.outBuffer;
        byte[] outArray = outBuffer.array();
        Deflater deflater = this.deflater;
        assert (outBuffer.arrayOffset() == 0);
        long cnt = 0L;
        for (int i = 0; i < length; ++i) {
            int rem2;
            ByteBuffer src = srcs[i + offset];
            while ((rem2 = src.remaining()) > 0) {
                int t;
                int c1;
                if (!outBuffer.hasRemaining()) {
                    outBuffer.flip();
                    try {
                        if (((StreamSinkConduit)this.next).write(outBuffer) == 0) {
                            long l = cnt;
                            return l;
                        }
                    }
                    finally {
                        outBuffer.compact();
                    }
                }
                int pos = src.position();
                if (src.hasArray()) {
                    byte[] array2 = src.array();
                    int arrayOffset = src.arrayOffset();
                    deflater.setInput(array2, arrayOffset + pos, rem2);
                    c1 = deflater.getTotalIn();
                    int dc = deflater.deflate(outArray, outBuffer.position(), outBuffer.remaining());
                    outBuffer.position(outBuffer.position() + dc);
                    t = deflater.getTotalIn() - c1;
                    src.position(pos + t);
                    cnt += (long)t;
                    continue;
                }
                byte[] bytes2 = Buffers.take(src);
                deflater.setInput(bytes2);
                c1 = deflater.getTotalIn();
                int dc = deflater.deflate(outArray, outBuffer.position(), outBuffer.remaining());
                outBuffer.position(outBuffer.position() + dc);
                t = deflater.getTotalIn() - c1;
                src.position(pos + t);
                cnt += (long)t;
            }
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flush() throws IOException {
        int pos;
        ByteBuffer outBuffer = this.outBuffer;
        byte[] outArray = outBuffer.array();
        Deflater deflater = this.deflater;
        assert (outBuffer.arrayOffset() == 0);
        deflater.setInput(NO_BYTES);
        while (true) {
            int rem2 = outBuffer.remaining();
            pos = outBuffer.position();
            int res = deflater.deflate(outArray, pos, rem2, 2);
            if (pos == 0 && res == rem2) {
                throw Messages.msg.flushSmallBuffer();
            }
            if (res <= 0) break;
            outBuffer.flip();
            try {
                if (((StreamSinkConduit)this.next).write(outBuffer) != 0) continue;
                boolean bl = false;
                return bl;
            }
            finally {
                outBuffer.compact();
                continue;
            }
            break;
        }
        if (deflater.needsInput() && pos == 0) {
            if (deflater.finished()) {
                ((StreamSinkConduit)this.next).terminateWrites();
            }
            return ((StreamSinkConduit)this.next).flush();
        }
        throw Messages.msg.deflaterState();
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return Conduits.writeFinalBasic(this, src);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic(this, srcs, offset, length);
    }

    @Override
    public void terminateWrites() throws IOException {
        this.deflater.finish();
    }

    @Override
    public void truncateWrites() throws IOException {
        this.deflater.finish();
        ((StreamSinkConduit)this.next).truncateWrites();
    }
}

