/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.lang.constant.Constable;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.MembershipKey;
import java.nio.channels.SelectionKey;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.Options;
import org.xnio.XnioExecutor;
import org.xnio.channels.MulticastMessageChannel;
import org.xnio.channels.ReadListenerSettable;
import org.xnio.channels.SocketAddressBuffer;
import org.xnio.channels.UnsupportedOptionException;
import org.xnio.channels.WriteListenerSettable;
import org.xnio.nio.AbstractNioChannel;
import org.xnio.nio.Log;
import org.xnio.nio.NioUdpChannelHandle;
import org.xnio.nio.NioXnioWorker;
import org.xnio.nio.SelectorUtils;
import org.xnio.nio.WorkerThread;

class NioUdpChannel
extends AbstractNioChannel<NioUdpChannel>
implements MulticastMessageChannel,
ReadListenerSettable<NioUdpChannel>,
WriteListenerSettable<NioUdpChannel> {
    private final NioUdpChannelHandle handle;
    private ChannelListener<? super NioUdpChannel> readListener;
    private ChannelListener<? super NioUdpChannel> writeListener;
    private final DatagramChannel datagramChannel;
    private final AtomicBoolean callFlag = new AtomicBoolean(false);
    private static final Set<Option<?>> OPTIONS = Option.setBuilder().add((Option<?>)Options.BROADCAST).add((Option<?>)Options.RECEIVE_BUFFER).add((Option<?>)Options.SEND_BUFFER).add((Option<?>)Options.IP_TRAFFIC_CLASS).add((Option<?>)Options.MULTICAST_TTL).create();

    NioUdpChannel(NioXnioWorker worker, DatagramChannel datagramChannel) throws ClosedChannelException {
        super(worker);
        this.datagramChannel = datagramChannel;
        WorkerThread workerThread = worker.chooseThread();
        SelectionKey key2 = workerThread.registerChannel(datagramChannel);
        this.handle = new NioUdpChannelHandle(workerThread, key2, this);
        key2.attach(this.handle);
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.datagramChannel.socket().getLocalSocketAddress();
    }

    @Override
    public <A extends SocketAddress> A getLocalAddress(Class<A> type2) {
        return (A)(type2.isInstance(this.getLocalAddress()) ? (SocketAddress)type2.cast(this.getLocalAddress()) : null);
    }

    @Override
    public int receiveFrom(SocketAddressBuffer addressBuffer, ByteBuffer buffer) throws IOException {
        SocketAddress sourceAddress;
        int o = buffer.remaining();
        try {
            sourceAddress = this.datagramChannel.receive(buffer);
        }
        catch (ClosedChannelException e2) {
            return -1;
        }
        if (sourceAddress == null) {
            return 0;
        }
        int t = o - buffer.remaining();
        if (addressBuffer != null) {
            addressBuffer.setSourceAddress(sourceAddress);
            addressBuffer.setDestinationAddress(null);
        }
        return t;
    }

    @Override
    public long receiveFrom(SocketAddressBuffer addressBuffer, ByteBuffer[] buffers) throws IOException {
        return this.receiveFrom(addressBuffer, buffers, 0, buffers.length);
    }

    @Override
    public long receiveFrom(SocketAddressBuffer addressBuffer, ByteBuffer[] buffers, int offs, int len) throws IOException {
        SocketAddress sourceAddress;
        if (len == 0) {
            return 0L;
        }
        if (len == 1) {
            return this.receiveFrom(addressBuffer, buffers[offs]);
        }
        int o = (int)Math.min(Buffers.remaining(buffers, offs, len), 65536L);
        ByteBuffer buffer = ByteBuffer.allocate(o);
        try {
            sourceAddress = this.datagramChannel.receive(buffer);
        }
        catch (ClosedChannelException e2) {
            return -1L;
        }
        if (sourceAddress == null) {
            return 0L;
        }
        int t = o - buffer.remaining();
        buffer.flip();
        Buffers.copy(buffers, offs, len, buffer);
        if (addressBuffer != null) {
            addressBuffer.setSourceAddress(sourceAddress);
            addressBuffer.setDestinationAddress(null);
        }
        return t;
    }

    @Override
    public boolean sendTo(SocketAddress target, ByteBuffer buffer) throws IOException {
        return this.datagramChannel.send(buffer, target) != 0;
    }

    @Override
    public boolean sendTo(SocketAddress target, ByteBuffer[] buffers) throws IOException {
        return this.sendTo(target, buffers, 0, buffers.length);
    }

    @Override
    public boolean sendTo(SocketAddress target, ByteBuffer[] buffers, int offset, int length) throws IOException {
        if (length == 0) {
            return false;
        }
        if (length == 1) {
            return this.sendTo(target, buffers[offset]);
        }
        long o = Buffers.remaining(buffers, offset, length);
        if (o > 65535L) {
            throw Log.log.bufferTooLarge();
        }
        ByteBuffer buffer = ByteBuffer.allocate((int)o);
        Buffers.copy(buffer, buffers, offset, length);
        buffer.flip();
        return this.datagramChannel.send(buffer, target) != 0;
    }

    @Override
    public ChannelListener<? super NioUdpChannel> getReadListener() {
        return this.readListener;
    }

    @Override
    public void setReadListener(ChannelListener<? super NioUdpChannel> readListener) {
        this.readListener = readListener;
    }

    @Override
    public ChannelListener<? super NioUdpChannel> getWriteListener() {
        return this.writeListener;
    }

    @Override
    public void setWriteListener(ChannelListener<? super NioUdpChannel> writeListener) {
        this.writeListener = writeListener;
    }

    public ChannelListener.Setter<NioUdpChannel> getReadSetter() {
        return new ReadListenerSettable.Setter<NioUdpChannel>(this);
    }

    public ChannelListener.Setter<NioUdpChannel> getWriteSetter() {
        return new WriteListenerSettable.Setter<NioUdpChannel>(this);
    }

    @Override
    public boolean flush() throws IOException {
        return true;
    }

    @Override
    public boolean isOpen() {
        return this.datagramChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        if (!this.callFlag.getAndSet(true)) {
            Log.udpServerChannelLog.tracef("Closing %s", (Object)this);
            try {
                this.cancelKeys();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.datagramChannel.close();
            }
            finally {
                this.invokeCloseHandler();
            }
        }
    }

    private void cancelKeys() {
        try {
            this.handle.cancelKey(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void suspendReads() {
        this.handle.suspend(1);
    }

    @Override
    public void suspendWrites() {
        this.handle.suspend(4);
    }

    @Override
    public void resumeReads() {
        this.handle.resume(1);
    }

    @Override
    public void resumeWrites() {
        this.handle.resume(4);
    }

    @Override
    public boolean isReadResumed() {
        return this.handle.isResumed(1);
    }

    @Override
    public boolean isWriteResumed() {
        return this.handle.isResumed(4);
    }

    @Override
    public void wakeupReads() {
        this.handle.wakeup(1);
    }

    @Override
    public void wakeupWrites() {
        this.handle.wakeup(4);
    }

    @Override
    public void shutdownReads() throws IOException {
        throw Log.log.unsupported("shutdownReads");
    }

    @Override
    public void shutdownWrites() throws IOException {
        throw Log.log.unsupported("shutdownWrites");
    }

    @Override
    public void awaitReadable() throws IOException {
        SelectorUtils.await(this.worker.getXnio(), this.datagramChannel, 1);
    }

    @Override
    public void awaitReadable(long time2, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.worker.getXnio(), this.datagramChannel, 1, time2, timeUnit);
    }

    @Override
    @Deprecated
    public XnioExecutor getReadThread() {
        return this.getIoThread();
    }

    @Override
    public void awaitWritable() throws IOException {
        SelectorUtils.await(this.worker.getXnio(), this.datagramChannel, 4);
    }

    @Override
    public void awaitWritable(long time2, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.worker.getXnio(), this.datagramChannel, 4, time2, timeUnit);
    }

    @Override
    @Deprecated
    public XnioExecutor getWriteThread() {
        return this.getIoThread();
    }

    @Override
    public MulticastMessageChannel.Key join(InetAddress group, NetworkInterface iface) throws IOException {
        return new NioKey(this.datagramChannel.join(group, iface));
    }

    @Override
    public MulticastMessageChannel.Key join(InetAddress group, NetworkInterface iface, InetAddress source2) throws IOException {
        return new NioKey(this.datagramChannel.join(group, iface, source2));
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return OPTIONS.contains(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws UnsupportedOptionException, IOException {
        DatagramChannel channel = this.datagramChannel;
        DatagramSocket socket = channel.socket();
        if (option == Options.RECEIVE_BUFFER) {
            return option.cast(socket.getReceiveBufferSize());
        }
        if (option == Options.SEND_BUFFER) {
            return option.cast(socket.getSendBufferSize());
        }
        if (option == Options.BROADCAST) {
            return option.cast(socket.getBroadcast());
        }
        if (option == Options.IP_TRAFFIC_CLASS) {
            return option.cast(socket.getTrafficClass());
        }
        if (option == Options.MULTICAST_TTL) {
            return option.cast(channel.getOption(StandardSocketOptions.IP_MULTICAST_TTL));
        }
        return null;
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        Constable old;
        DatagramChannel channel = this.datagramChannel;
        DatagramSocket socket = channel.socket();
        if (option == Options.RECEIVE_BUFFER) {
            old = socket.getReceiveBufferSize();
            int newValue = Options.RECEIVE_BUFFER.cast(value, 65536);
            if (newValue < 1) {
                throw Log.log.optionOutOfRange("RECEIVE_BUFFER");
            }
            socket.setReceiveBufferSize(newValue);
        } else if (option == Options.SEND_BUFFER) {
            old = socket.getSendBufferSize();
            int newValue = Options.SEND_BUFFER.cast(value, 65536);
            if (newValue < 1) {
                throw Log.log.optionOutOfRange("SEND_BUFFER");
            }
            socket.setSendBufferSize(newValue);
        } else if (option == Options.IP_TRAFFIC_CLASS) {
            old = socket.getTrafficClass();
            socket.setTrafficClass(Options.IP_TRAFFIC_CLASS.cast(value, 0));
        } else if (option == Options.BROADCAST) {
            old = Boolean.valueOf(socket.getBroadcast());
            socket.setBroadcast(Options.BROADCAST.cast(value, Boolean.FALSE));
        } else if (option == Options.MULTICAST_TTL) {
            old = option.cast(channel.getOption(StandardSocketOptions.IP_MULTICAST_TTL));
            channel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Integer)value);
        } else {
            return null;
        }
        return option.cast(old);
    }

    public String toString() {
        return String.format("UDP socket channel (NIO) <%h>", this);
    }

    class NioKey
    implements MulticastMessageChannel.Key {
        private final MembershipKey key;

        NioKey(MembershipKey key2) {
            this.key = key2;
        }

        @Override
        public MulticastMessageChannel.Key block(InetAddress source2) throws IOException, UnsupportedOperationException, IllegalStateException, IllegalArgumentException {
            this.key.block(source2);
            return this;
        }

        @Override
        public MulticastMessageChannel.Key unblock(InetAddress source2) throws IOException, IllegalStateException, UnsupportedOperationException {
            this.key.unblock(source2);
            return this;
        }

        @Override
        public MulticastMessageChannel getChannel() {
            return NioUdpChannel.this;
        }

        @Override
        public InetAddress getGroup() {
            return this.key.group();
        }

        @Override
        public NetworkInterface getNetworkInterface() {
            return this.key.networkInterface();
        }

        @Override
        public InetAddress getSourceAddress() {
            return this.key.sourceAddress();
        }

        @Override
        public boolean isOpen() {
            return this.key.isValid();
        }

        @Override
        public void close() throws IOException {
            this.key.drop();
        }
    }
}

